// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.exception.MissingUserIdException
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.api.AdminNotificationDto
import org.jellyfin.sdk.model.api.NameIdPair
import org.jellyfin.sdk.model.api.NotificationResultDto
import org.jellyfin.sdk.model.api.NotificationTypeInfo
import org.jellyfin.sdk.model.api.NotificationsSummaryDto

public class NotificationsApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Sends a notification to all admins.
	 */
	public suspend fun createAdminNotification(`data`: AdminNotificationDto): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Notifications/Admin", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets notification services.
	 */
	public suspend fun getNotificationServices(): Response<List<NameIdPair>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<NameIdPair>>("/Notifications/Services", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets notification types.
	 */
	public suspend fun getNotificationTypes(): Response<List<NotificationTypeInfo>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<NotificationTypeInfo>>("/Notifications/Types", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets a user's notifications.
	 */
	public suspend fun getNotifications(userId: String = api.userId?.toString() ?: throw
			MissingUserIdException()): Response<NotificationResultDto> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<NotificationResultDto>("/Notifications/{userId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets a user's notification summary.
	 */
	public suspend fun getNotificationsSummary(userId: String = api.userId?.toString() ?: throw
			MissingUserIdException()): Response<NotificationsSummaryDto> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<NotificationsSummaryDto>("/Notifications/{userId}/Summary",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Sets notifications as read.
	 */
	public suspend fun setRead(userId: String = api.userId?.toString() ?: throw
			MissingUserIdException()): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.post<Unit>("/Notifications/{userId}/Read", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Sets notifications as unread.
	 */
	public suspend fun setUnread(userId: String = api.userId?.toString() ?: throw
			MissingUserIdException()): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.post<Unit>("/Notifications/{userId}/Unread", pathParameters, queryParameters,
				data)
		return response
	}
}
