// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.api.client.extensions.delete
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.PackageInfo
import org.jellyfin.sdk.model.api.RepositoryInfo

public class PackageApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Cancels a package installation.
	 *
	 * @param packageId Installation Id.
	 */
	public suspend fun cancelPackageInstallation(packageId: UUID): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("packageId", packageId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.delete<Unit>("/Packages/Installing/{packageId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets a package by name or assembly GUID.
	 *
	 * @param name The name of the package.
	 * @param assemblyGuid The GUID of the associated assembly.
	 */
	public suspend fun getPackageInfo(name: String, assemblyGuid: UUID? = null):
			Response<PackageInfo> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("name", name)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("assemblyGuid", assemblyGuid)
		}
		val data = null
		val response = api.`get`<PackageInfo>("/Packages/{name}", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets available packages.
	 */
	public suspend fun getPackages(): Response<List<PackageInfo>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<PackageInfo>>("/Packages", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets all package repositories.
	 */
	public suspend fun getRepositories(): Response<List<RepositoryInfo>> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<RepositoryInfo>>("/Repositories", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Installs a package.
	 *
	 * @param name Package name.
	 * @param assemblyGuid GUID of the associated assembly.
	 * @param version Optional version. Defaults to latest version.
	 * @param repositoryUrl Optional. Specify the repository to install from.
	 */
	public suspend fun installPackage(
		name: String,
		assemblyGuid: UUID? = null,
		version: String? = null,
		repositoryUrl: String? = null,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("name", name)
		}
		val queryParameters = buildMap<String, Any?>(3) {
			put("assemblyGuid", assemblyGuid)
			put("version", version)
			put("repositoryUrl", repositoryUrl)
		}
		val data = null
		val response = api.post<Unit>("/Packages/Installed/{name}", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Sets the enabled and existing package repositories.
	 */
	public suspend fun setRepositories(`data`: List<RepositoryInfo>): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Repositories", pathParameters, queryParameters, data)
		return response
	}
}
