// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemDto
import org.jellyfin.sdk.model.api.BaseItemDtoQueryResult
import org.jellyfin.sdk.model.api.ImageType
import org.jellyfin.sdk.model.api.ItemFields
import org.jellyfin.sdk.model.api.ItemFilter
import org.jellyfin.sdk.model.api.request.GetPersonsRequest

public class PersonsApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Get person by name.
	 *
	 * @param name Person name.
	 * @param userId Optional. Filter by user id, and attach user data.
	 */
	public suspend fun getPerson(name: String, userId: UUID? = null): Response<BaseItemDto> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("name", name)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val data = null
		val response = api.`get`<BaseItemDto>("/Persons/{name}", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets all persons.
	 *
	 * @param limit Optional. The maximum number of records to return.
	 * @param searchTerm The search term.
	 * @param fields Optional. Specify additional fields of information to return in the output.
	 * @param filters Optional. Specify additional filters to apply.
	 * @param isFavorite Optional filter by items that are marked as favorite, or not. userId is
	 * required.
	 * @param enableUserData Optional, include user data.
	 * @param imageTypeLimit Optional, the max number of images to return, per image type.
	 * @param enableImageTypes Optional. The image types to include in the output.
	 * @param excludePersonTypes Optional. If specified results will be filtered to exclude those
	 * containing the specified PersonType. Allows multiple, comma-delimited.
	 * @param personTypes Optional. If specified results will be filtered to include only those
	 * containing the specified PersonType. Allows multiple, comma-delimited.
	 * @param appearsInItemId Optional. If specified, person results will be filtered on items related
	 * to said persons.
	 * @param userId User id.
	 * @param enableImages Optional, include image information in output.
	 */
	public suspend fun getPersons(
		limit: Int? = null,
		searchTerm: String? = null,
		fields: Collection<ItemFields>? = emptyList(),
		filters: Collection<ItemFilter>? = emptyList(),
		isFavorite: Boolean? = null,
		enableUserData: Boolean? = null,
		imageTypeLimit: Int? = null,
		enableImageTypes: Collection<ImageType>? = emptyList(),
		excludePersonTypes: Collection<String>? = emptyList(),
		personTypes: Collection<String>? = emptyList(),
		appearsInItemId: UUID? = null,
		userId: UUID? = null,
		enableImages: Boolean? = true,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(13) {
			put("limit", limit)
			put("searchTerm", searchTerm)
			put("fields", fields)
			put("filters", filters)
			put("isFavorite", isFavorite)
			put("enableUserData", enableUserData)
			put("imageTypeLimit", imageTypeLimit)
			put("enableImageTypes", enableImageTypes)
			put("excludePersonTypes", excludePersonTypes)
			put("personTypes", personTypes)
			put("appearsInItemId", appearsInItemId)
			put("userId", userId)
			put("enableImages", enableImages)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Persons", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Gets all persons.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getPersons(request: GetPersonsRequest = GetPersonsRequest()):
			Response<BaseItemDtoQueryResult> = getPersons(
		limit = request.limit,
		searchTerm = request.searchTerm,
		fields = request.fields,
		filters = request.filters,
		isFavorite = request.isFavorite,
		enableUserData = request.enableUserData,
		imageTypeLimit = request.imageTypeLimit,
		enableImageTypes = request.enableImageTypes,
		excludePersonTypes = request.excludePersonTypes,
		personTypes = request.personTypes,
		appearsInItemId = request.appearsInItemId,
		userId = request.userId,
		enableImages = request.enableImages,
	)
}
