// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.exception.MissingUserIdException
import org.jellyfin.sdk.api.client.extensions.delete
import org.jellyfin.sdk.api.client.extensions.post
import org.jellyfin.sdk.model.DateTime
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.PlayMethod
import org.jellyfin.sdk.model.api.PlaybackProgressInfo
import org.jellyfin.sdk.model.api.PlaybackStartInfo
import org.jellyfin.sdk.model.api.PlaybackStopInfo
import org.jellyfin.sdk.model.api.RepeatMode
import org.jellyfin.sdk.model.api.UserItemDataDto
import org.jellyfin.sdk.model.api.request.OnPlaybackProgressRequest
import org.jellyfin.sdk.model.api.request.OnPlaybackStartRequest
import org.jellyfin.sdk.model.api.request.OnPlaybackStoppedRequest

public class PlayStateApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Marks an item as played for user.
	 *
	 * @param userId User id.
	 * @param itemId Item id.
	 * @param datePlayed Optional. The date the item was played.
	 */
	public suspend fun markPlayedItem(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		itemId: UUID,
		datePlayed: DateTime? = null,
	): Response<UserItemDataDto> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(1) {
			put("datePlayed", datePlayed)
		}
		val data = null
		val response = api.post<UserItemDataDto>("/Users/{userId}/PlayedItems/{itemId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Marks an item as unplayed for user.
	 *
	 * @param userId User id.
	 * @param itemId Item id.
	 */
	public suspend fun markUnplayedItem(userId: UUID = api.userId ?: throw MissingUserIdException(),
			itemId: UUID): Response<UserItemDataDto> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("itemId", itemId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.delete<UserItemDataDto>("/Users/{userId}/PlayedItems/{itemId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Reports a user's playback progress.
	 *
	 * @param userId User id.
	 * @param itemId Item id.
	 * @param mediaSourceId The id of the MediaSource.
	 * @param positionTicks Optional. The current position, in ticks. 1 tick = 10000 ms.
	 * @param audioStreamIndex The audio stream index.
	 * @param subtitleStreamIndex The subtitle stream index.
	 * @param volumeLevel Scale of 0-100.
	 * @param playMethod The play method.
	 * @param liveStreamId The live stream id.
	 * @param playSessionId The play session id.
	 * @param repeatMode The repeat mode.
	 * @param isPaused Indicates if the player is paused.
	 * @param isMuted Indicates if the player is muted.
	 */
	public suspend fun onPlaybackProgress(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		itemId: UUID,
		mediaSourceId: String? = null,
		positionTicks: Long? = null,
		audioStreamIndex: Int? = null,
		subtitleStreamIndex: Int? = null,
		volumeLevel: Int? = null,
		playMethod: PlayMethod? = null,
		liveStreamId: String? = null,
		playSessionId: String? = null,
		repeatMode: RepeatMode? = null,
		isPaused: Boolean? = false,
		isMuted: Boolean? = false,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(11) {
			put("mediaSourceId", mediaSourceId)
			put("positionTicks", positionTicks)
			put("audioStreamIndex", audioStreamIndex)
			put("subtitleStreamIndex", subtitleStreamIndex)
			put("volumeLevel", volumeLevel)
			put("playMethod", playMethod)
			put("liveStreamId", liveStreamId)
			put("playSessionId", playSessionId)
			put("repeatMode", repeatMode)
			put("isPaused", isPaused)
			put("isMuted", isMuted)
		}
		val data = null
		val response = api.post<Unit>("/Users/{userId}/PlayingItems/{itemId}/Progress", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Reports a user's playback progress.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun onPlaybackProgress(request: OnPlaybackProgressRequest): Response<Unit> =
			onPlaybackProgress(
		userId = request.userId,
		itemId = request.itemId,
		mediaSourceId = request.mediaSourceId,
		positionTicks = request.positionTicks,
		audioStreamIndex = request.audioStreamIndex,
		subtitleStreamIndex = request.subtitleStreamIndex,
		volumeLevel = request.volumeLevel,
		playMethod = request.playMethod,
		liveStreamId = request.liveStreamId,
		playSessionId = request.playSessionId,
		repeatMode = request.repeatMode,
		isPaused = request.isPaused,
		isMuted = request.isMuted,
	)

	/**
	 * Reports that a user has begun playing an item.
	 *
	 * @param userId User id.
	 * @param itemId Item id.
	 * @param mediaSourceId The id of the MediaSource.
	 * @param audioStreamIndex The audio stream index.
	 * @param subtitleStreamIndex The subtitle stream index.
	 * @param playMethod The play method.
	 * @param liveStreamId The live stream id.
	 * @param playSessionId The play session id.
	 * @param canSeek Indicates if the client can seek.
	 */
	public suspend fun onPlaybackStart(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		itemId: UUID,
		mediaSourceId: String? = null,
		audioStreamIndex: Int? = null,
		subtitleStreamIndex: Int? = null,
		playMethod: PlayMethod? = null,
		liveStreamId: String? = null,
		playSessionId: String? = null,
		canSeek: Boolean? = false,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(7) {
			put("mediaSourceId", mediaSourceId)
			put("audioStreamIndex", audioStreamIndex)
			put("subtitleStreamIndex", subtitleStreamIndex)
			put("playMethod", playMethod)
			put("liveStreamId", liveStreamId)
			put("playSessionId", playSessionId)
			put("canSeek", canSeek)
		}
		val data = null
		val response = api.post<Unit>("/Users/{userId}/PlayingItems/{itemId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Reports that a user has begun playing an item.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun onPlaybackStart(request: OnPlaybackStartRequest): Response<Unit> =
			onPlaybackStart(
		userId = request.userId,
		itemId = request.itemId,
		mediaSourceId = request.mediaSourceId,
		audioStreamIndex = request.audioStreamIndex,
		subtitleStreamIndex = request.subtitleStreamIndex,
		playMethod = request.playMethod,
		liveStreamId = request.liveStreamId,
		playSessionId = request.playSessionId,
		canSeek = request.canSeek,
	)

	/**
	 * Reports that a user has stopped playing an item.
	 *
	 * @param userId User id.
	 * @param itemId Item id.
	 * @param mediaSourceId The id of the MediaSource.
	 * @param nextMediaType The next media type that will play.
	 * @param positionTicks Optional. The position, in ticks, where playback stopped. 1 tick = 10000
	 * ms.
	 * @param liveStreamId The live stream id.
	 * @param playSessionId The play session id.
	 */
	public suspend fun onPlaybackStopped(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		itemId: UUID,
		mediaSourceId: String? = null,
		nextMediaType: String? = null,
		positionTicks: Long? = null,
		liveStreamId: String? = null,
		playSessionId: String? = null,
	): Response<Unit> {
		val pathParameters = buildMap<String, Any?>(2) {
			put("userId", userId)
			put("itemId", itemId)
		}
		val queryParameters = buildMap<String, Any?>(5) {
			put("mediaSourceId", mediaSourceId)
			put("nextMediaType", nextMediaType)
			put("positionTicks", positionTicks)
			put("liveStreamId", liveStreamId)
			put("playSessionId", playSessionId)
		}
		val data = null
		val response = api.delete<Unit>("/Users/{userId}/PlayingItems/{itemId}", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Reports that a user has stopped playing an item.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun onPlaybackStopped(request: OnPlaybackStoppedRequest): Response<Unit> =
			onPlaybackStopped(
		userId = request.userId,
		itemId = request.itemId,
		mediaSourceId = request.mediaSourceId,
		nextMediaType = request.nextMediaType,
		positionTicks = request.positionTicks,
		liveStreamId = request.liveStreamId,
		playSessionId = request.playSessionId,
	)

	/**
	 * Pings a playback session.
	 *
	 * @param playSessionId Playback session id.
	 */
	public suspend fun pingPlaybackSession(playSessionId: String): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(1) {
			put("playSessionId", playSessionId)
		}
		val data = null
		val response = api.post<Unit>("/Sessions/Playing/Ping", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Reports playback progress within a session.
	 */
	public suspend fun reportPlaybackProgress(`data`: PlaybackProgressInfo? = null): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Sessions/Playing/Progress", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Reports playback has started within a session.
	 */
	public suspend fun reportPlaybackStart(`data`: PlaybackStartInfo? = null): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Sessions/Playing", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Reports playback has stopped within a session.
	 */
	public suspend fun reportPlaybackStopped(`data`: PlaybackStopInfo? = null): Response<Unit> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = emptyMap<String, Any?>()
		val response = api.post<Unit>("/Sessions/Playing/Stopped", pathParameters, queryParameters, data)
		return response
	}
}
