// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemKind
import org.jellyfin.sdk.model.api.SearchHintResult
import org.jellyfin.sdk.model.api.request.GetRequest

public class SearchApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Gets the search hint result.
	 *
	 * @param startIndex Optional. The record index to start at. All items with a lower index will be
	 * dropped from the results.
	 * @param limit Optional. The maximum number of records to return.
	 * @param userId Optional. Supply a user id to search within a user's library or omit to search
	 * all.
	 * @param searchTerm The search term to filter on.
	 * @param includeItemTypes If specified, only results with the specified item types are returned.
	 * This allows multiple, comma delimeted.
	 * @param excludeItemTypes If specified, results with these item types are filtered out. This
	 * allows multiple, comma delimeted.
	 * @param mediaTypes If specified, only results with the specified media types are returned. This
	 * allows multiple, comma delimeted.
	 * @param parentId If specified, only children of the parent are returned.
	 * @param isMovie Optional filter for movies.
	 * @param isSeries Optional filter for series.
	 * @param isNews Optional filter for news.
	 * @param isKids Optional filter for kids.
	 * @param isSports Optional filter for sports.
	 * @param includePeople Optional filter whether to include people.
	 * @param includeMedia Optional filter whether to include media.
	 * @param includeGenres Optional filter whether to include genres.
	 * @param includeStudios Optional filter whether to include studios.
	 * @param includeArtists Optional filter whether to include artists.
	 */
	public suspend fun `get`(
		startIndex: Int? = null,
		limit: Int? = null,
		userId: UUID? = null,
		searchTerm: String,
		includeItemTypes: Collection<BaseItemKind>? = emptyList(),
		excludeItemTypes: Collection<BaseItemKind>? = emptyList(),
		mediaTypes: Collection<String>? = emptyList(),
		parentId: UUID? = null,
		isMovie: Boolean? = null,
		isSeries: Boolean? = null,
		isNews: Boolean? = null,
		isKids: Boolean? = null,
		isSports: Boolean? = null,
		includePeople: Boolean? = true,
		includeMedia: Boolean? = true,
		includeGenres: Boolean? = true,
		includeStudios: Boolean? = true,
		includeArtists: Boolean? = true,
	): Response<SearchHintResult> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(18) {
			put("startIndex", startIndex)
			put("limit", limit)
			put("userId", userId)
			put("searchTerm", searchTerm)
			put("includeItemTypes", includeItemTypes)
			put("excludeItemTypes", excludeItemTypes)
			put("mediaTypes", mediaTypes)
			put("parentId", parentId)
			put("isMovie", isMovie)
			put("isSeries", isSeries)
			put("isNews", isNews)
			put("isKids", isKids)
			put("isSports", isSports)
			put("includePeople", includePeople)
			put("includeMedia", includeMedia)
			put("includeGenres", includeGenres)
			put("includeStudios", includeStudios)
			put("includeArtists", includeArtists)
		}
		val data = null
		val response = api.`get`<SearchHintResult>("/Search/Hints", pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Gets the search hint result.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun `get`(request: GetRequest): Response<SearchHintResult> = `get`(
		startIndex = request.startIndex,
		limit = request.limit,
		userId = request.userId,
		searchTerm = request.searchTerm,
		includeItemTypes = request.includeItemTypes,
		excludeItemTypes = request.excludeItemTypes,
		mediaTypes = request.mediaTypes,
		parentId = request.parentId,
		isMovie = request.isMovie,
		isSeries = request.isSeries,
		isNews = request.isNews,
		isKids = request.isKids,
		isSports = request.isSports,
		includePeople = request.includePeople,
		includeMedia = request.includeMedia,
		includeGenres = request.includeGenres,
		includeStudios = request.includeStudios,
		includeArtists = request.includeArtists,
	)
}
