// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.exception.MissingUserIdException
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemDtoQueryResult
import org.jellyfin.sdk.model.api.BaseItemKind
import org.jellyfin.sdk.model.api.request.GetSuggestionsRequest

public class SuggestionsApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Gets suggestions.
	 *
	 * @param userId The user id.
	 * @param mediaType The media types.
	 * @param type The type.
	 * @param startIndex Optional. The start index.
	 * @param limit Optional. The limit.
	 * @param enableTotalRecordCount Whether to enable the total record count.
	 */
	public suspend fun getSuggestions(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		mediaType: Collection<String>? = emptyList(),
		type: Collection<BaseItemKind>? = emptyList(),
		startIndex: Int? = null,
		limit: Int? = null,
		enableTotalRecordCount: Boolean? = false,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = buildMap<String, Any?>(5) {
			put("mediaType", mediaType)
			put("type", type)
			put("startIndex", startIndex)
			put("limit", limit)
			put("enableTotalRecordCount", enableTotalRecordCount)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Users/{userId}/Suggestions", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets suggestions.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getSuggestions(request: GetSuggestionsRequest): Response<BaseItemDtoQueryResult>
			= getSuggestions(
		userId = request.userId,
		mediaType = request.mediaType,
		type = request.type,
		startIndex = request.startIndex,
		limit = request.limit,
		enableTotalRecordCount = request.enableTotalRecordCount,
	)
}
