// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.DateTime
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemDtoQueryResult
import org.jellyfin.sdk.model.api.ImageType
import org.jellyfin.sdk.model.api.ItemFields
import org.jellyfin.sdk.model.api.request.GetEpisodesRequest
import org.jellyfin.sdk.model.api.request.GetNextUpRequest
import org.jellyfin.sdk.model.api.request.GetSeasonsRequest
import org.jellyfin.sdk.model.api.request.GetUpcomingEpisodesRequest

public class TvShowsApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Gets episodes for a tv season.
	 *
	 * @param seriesId The series id.
	 * @param userId The user id.
	 * @param fields Optional. Specify additional fields of information to return in the output. This
	 * allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl,
	 * IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio,
	 * Revenue, SortName, Studios, Taglines, TrailerUrls.
	 * @param season Optional filter by season number.
	 * @param seasonId Optional. Filter by season id.
	 * @param isMissing Optional. Filter by items that are missing episodes or not.
	 * @param adjacentTo Optional. Return items that are siblings of a supplied item.
	 * @param startItemId Optional. Skip through the list until a given item is found.
	 * @param startIndex Optional. The record index to start at. All items with a lower index will be
	 * dropped from the results.
	 * @param limit Optional. The maximum number of records to return.
	 * @param enableImages Optional, include image information in output.
	 * @param imageTypeLimit Optional, the max number of images to return, per image type.
	 * @param enableImageTypes Optional. The image types to include in the output.
	 * @param enableUserData Optional. Include user data.
	 * @param sortBy Optional. Specify one or more sort orders, comma delimited. Options: Album,
	 * AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount,
	 * PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
	 */
	public suspend fun getEpisodes(
		seriesId: UUID,
		userId: UUID? = null,
		fields: Collection<ItemFields>? = emptyList(),
		season: Int? = null,
		seasonId: UUID? = null,
		isMissing: Boolean? = null,
		adjacentTo: String? = null,
		startItemId: UUID? = null,
		startIndex: Int? = null,
		limit: Int? = null,
		enableImages: Boolean? = null,
		imageTypeLimit: Int? = null,
		enableImageTypes: Collection<ImageType>? = emptyList(),
		enableUserData: Boolean? = null,
		sortBy: String? = null,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("seriesId", seriesId)
		}
		val queryParameters = buildMap<String, Any?>(14) {
			put("userId", userId)
			put("fields", fields)
			put("season", season)
			put("seasonId", seasonId)
			put("isMissing", isMissing)
			put("adjacentTo", adjacentTo)
			put("startItemId", startItemId)
			put("startIndex", startIndex)
			put("limit", limit)
			put("enableImages", enableImages)
			put("imageTypeLimit", imageTypeLimit)
			put("enableImageTypes", enableImageTypes)
			put("enableUserData", enableUserData)
			put("sortBy", sortBy)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Shows/{seriesId}/Episodes", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets episodes for a tv season.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getEpisodes(request: GetEpisodesRequest): Response<BaseItemDtoQueryResult> =
			getEpisodes(
		seriesId = request.seriesId,
		userId = request.userId,
		fields = request.fields,
		season = request.season,
		seasonId = request.seasonId,
		isMissing = request.isMissing,
		adjacentTo = request.adjacentTo,
		startItemId = request.startItemId,
		startIndex = request.startIndex,
		limit = request.limit,
		enableImages = request.enableImages,
		imageTypeLimit = request.imageTypeLimit,
		enableImageTypes = request.enableImageTypes,
		enableUserData = request.enableUserData,
		sortBy = request.sortBy,
	)

	/**
	 * Gets a list of next up episodes.
	 *
	 * @param userId The user id of the user to get the next up episodes for.
	 * @param startIndex Optional. The record index to start at. All items with a lower index will be
	 * dropped from the results.
	 * @param limit Optional. The maximum number of records to return.
	 * @param fields Optional. Specify additional fields of information to return in the output.
	 * @param seriesId Optional. Filter by series id.
	 * @param parentId Optional. Specify this to localize the search to a specific item or folder. Omit
	 * to use the root.
	 * @param enableImages Optional. Include image information in output.
	 * @param imageTypeLimit Optional. The max number of images to return, per image type.
	 * @param enableImageTypes Optional. The image types to include in the output.
	 * @param enableUserData Optional. Include user data.
	 * @param nextUpDateCutoff Optional. Starting date of shows to show in Next Up section.
	 * @param enableTotalRecordCount Whether to enable the total records count. Defaults to true.
	 * @param disableFirstEpisode Whether to disable sending the first episode in a series as next up.
	 * @param enableRewatching Whether to include watched episode in next up results.
	 */
	public suspend fun getNextUp(
		userId: UUID? = null,
		startIndex: Int? = null,
		limit: Int? = null,
		fields: Collection<ItemFields>? = emptyList(),
		seriesId: String? = null,
		parentId: UUID? = null,
		enableImages: Boolean? = null,
		imageTypeLimit: Int? = null,
		enableImageTypes: Collection<ImageType>? = emptyList(),
		enableUserData: Boolean? = null,
		nextUpDateCutoff: DateTime? = null,
		enableTotalRecordCount: Boolean? = true,
		disableFirstEpisode: Boolean? = false,
		enableRewatching: Boolean? = false,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(14) {
			put("userId", userId)
			put("startIndex", startIndex)
			put("limit", limit)
			put("fields", fields)
			put("seriesId", seriesId)
			put("parentId", parentId)
			put("enableImages", enableImages)
			put("imageTypeLimit", imageTypeLimit)
			put("enableImageTypes", enableImageTypes)
			put("enableUserData", enableUserData)
			put("nextUpDateCutoff", nextUpDateCutoff)
			put("enableTotalRecordCount", enableTotalRecordCount)
			put("disableFirstEpisode", disableFirstEpisode)
			put("enableRewatching", enableRewatching)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Shows/NextUp", pathParameters, queryParameters,
				data)
		return response
	}

	/**
	 * Gets a list of next up episodes.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getNextUp(request: GetNextUpRequest = GetNextUpRequest()):
			Response<BaseItemDtoQueryResult> = getNextUp(
		userId = request.userId,
		startIndex = request.startIndex,
		limit = request.limit,
		fields = request.fields,
		seriesId = request.seriesId,
		parentId = request.parentId,
		enableImages = request.enableImages,
		imageTypeLimit = request.imageTypeLimit,
		enableImageTypes = request.enableImageTypes,
		enableUserData = request.enableUserData,
		nextUpDateCutoff = request.nextUpDateCutoff,
		enableTotalRecordCount = request.enableTotalRecordCount,
		disableFirstEpisode = request.disableFirstEpisode,
		enableRewatching = request.enableRewatching,
	)

	/**
	 * Gets seasons for a tv series.
	 *
	 * @param seriesId The series id.
	 * @param userId The user id.
	 * @param fields Optional. Specify additional fields of information to return in the output. This
	 * allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl,
	 * IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio,
	 * Revenue, SortName, Studios, Taglines, TrailerUrls.
	 * @param isSpecialSeason Optional. Filter by special season.
	 * @param isMissing Optional. Filter by items that are missing episodes or not.
	 * @param adjacentTo Optional. Return items that are siblings of a supplied item.
	 * @param enableImages Optional. Include image information in output.
	 * @param imageTypeLimit Optional. The max number of images to return, per image type.
	 * @param enableImageTypes Optional. The image types to include in the output.
	 * @param enableUserData Optional. Include user data.
	 */
	public suspend fun getSeasons(
		seriesId: UUID,
		userId: UUID? = null,
		fields: Collection<ItemFields>? = emptyList(),
		isSpecialSeason: Boolean? = null,
		isMissing: Boolean? = null,
		adjacentTo: String? = null,
		enableImages: Boolean? = null,
		imageTypeLimit: Int? = null,
		enableImageTypes: Collection<ImageType>? = emptyList(),
		enableUserData: Boolean? = null,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("seriesId", seriesId)
		}
		val queryParameters = buildMap<String, Any?>(9) {
			put("userId", userId)
			put("fields", fields)
			put("isSpecialSeason", isSpecialSeason)
			put("isMissing", isMissing)
			put("adjacentTo", adjacentTo)
			put("enableImages", enableImages)
			put("imageTypeLimit", imageTypeLimit)
			put("enableImageTypes", enableImageTypes)
			put("enableUserData", enableUserData)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Shows/{seriesId}/Seasons", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets seasons for a tv series.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getSeasons(request: GetSeasonsRequest): Response<BaseItemDtoQueryResult> =
			getSeasons(
		seriesId = request.seriesId,
		userId = request.userId,
		fields = request.fields,
		isSpecialSeason = request.isSpecialSeason,
		isMissing = request.isMissing,
		adjacentTo = request.adjacentTo,
		enableImages = request.enableImages,
		imageTypeLimit = request.imageTypeLimit,
		enableImageTypes = request.enableImageTypes,
		enableUserData = request.enableUserData,
	)

	/**
	 * Gets a list of upcoming episodes.
	 *
	 * @param userId The user id of the user to get the upcoming episodes for.
	 * @param startIndex Optional. The record index to start at. All items with a lower index will be
	 * dropped from the results.
	 * @param limit Optional. The maximum number of records to return.
	 * @param fields Optional. Specify additional fields of information to return in the output.
	 * @param parentId Optional. Specify this to localize the search to a specific item or folder. Omit
	 * to use the root.
	 * @param enableImages Optional. Include image information in output.
	 * @param imageTypeLimit Optional. The max number of images to return, per image type.
	 * @param enableImageTypes Optional. The image types to include in the output.
	 * @param enableUserData Optional. Include user data.
	 */
	public suspend fun getUpcomingEpisodes(
		userId: UUID? = null,
		startIndex: Int? = null,
		limit: Int? = null,
		fields: Collection<ItemFields>? = emptyList(),
		parentId: UUID? = null,
		enableImages: Boolean? = null,
		imageTypeLimit: Int? = null,
		enableImageTypes: Collection<ImageType>? = emptyList(),
		enableUserData: Boolean? = null,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = emptyMap<String, Any?>()
		val queryParameters = buildMap<String, Any?>(9) {
			put("userId", userId)
			put("startIndex", startIndex)
			put("limit", limit)
			put("fields", fields)
			put("parentId", parentId)
			put("enableImages", enableImages)
			put("imageTypeLimit", imageTypeLimit)
			put("enableImageTypes", enableImageTypes)
			put("enableUserData", enableUserData)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Shows/Upcoming", pathParameters,
				queryParameters, data)
		return response
	}

	/**
	 * Gets a list of upcoming episodes.
	 *
	 * @param request The request paramaters
	 */
	public suspend fun getUpcomingEpisodes(request: GetUpcomingEpisodesRequest =
			GetUpcomingEpisodesRequest()): Response<BaseItemDtoQueryResult> = getUpcomingEpisodes(
		userId = request.userId,
		startIndex = request.startIndex,
		limit = request.limit,
		fields = request.fields,
		parentId = request.parentId,
		enableImages = request.enableImages,
		imageTypeLimit = request.imageTypeLimit,
		enableImageTypes = request.enableImageTypes,
		enableUserData = request.enableUserData,
	)
}
