// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.List
import kotlin.collections.buildMap
import kotlin.collections.emptyList
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.exception.MissingUserIdException
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID
import org.jellyfin.sdk.model.api.BaseItemDtoQueryResult
import org.jellyfin.sdk.model.api.SpecialViewOptionDto

public class UserViewsApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Get user view grouping options.
	 *
	 * @param userId User id.
	 */
	public suspend fun getGroupingOptions(userId: UUID = api.userId ?: throw MissingUserIdException()):
			Response<List<SpecialViewOptionDto>> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<List<SpecialViewOptionDto>>("/Users/{userId}/GroupingOptions",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get user views.
	 *
	 * @param userId User id.
	 * @param includeExternalContent Whether or not to include external views such as channels or live
	 * tv.
	 * @param presetViews Preset views.
	 * @param includeHidden Whether or not to include hidden content.
	 */
	public suspend fun getUserViews(
		userId: UUID = api.userId ?: throw MissingUserIdException(),
		includeExternalContent: Boolean? = null,
		presetViews: Collection<String>? = emptyList(),
		includeHidden: Boolean? = false,
	): Response<BaseItemDtoQueryResult> {
		val pathParameters = buildMap<String, Any?>(1) {
			put("userId", userId)
		}
		val queryParameters = buildMap<String, Any?>(3) {
			put("includeExternalContent", includeExternalContent)
			put("presetViews", presetViews)
			put("includeHidden", includeHidden)
		}
		val data = null
		val response = api.`get`<BaseItemDtoQueryResult>("/Users/{userId}/Views", pathParameters,
				queryParameters, data)
		return response
	}
}
