// !!        WARNING
// !! DO NOT EDIT THIS FILE
//
// This file is generated by the openapi-generator module and is not meant for manual changes.
// Please read the README.md file in the openapi-generator module for additional information.
package org.jellyfin.sdk.api.operations

import io.ktor.utils.io.ByteReadChannel
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.buildMap
import kotlin.collections.emptyMap
import org.jellyfin.sdk.api.client.ApiClient
import org.jellyfin.sdk.api.client.Response
import org.jellyfin.sdk.api.client.extensions.`get`
import org.jellyfin.sdk.model.UUID

public class VideoAttachmentsApi(
	private val api: ApiClient,
) : Api {
	/**
	 * Get video attachment.
	 *
	 * @param videoId Video ID.
	 * @param mediaSourceId Media Source ID.
	 * @param index Attachment Index.
	 */
	public suspend fun getAttachment(
		videoId: UUID,
		mediaSourceId: String,
		index: Int,
	): Response<ByteReadChannel> {
		val pathParameters = buildMap<String, Any?>(3) {
			put("videoId", videoId)
			put("mediaSourceId", mediaSourceId)
			put("index", index)
		}
		val queryParameters = emptyMap<String, Any?>()
		val data = null
		val response = api.`get`<ByteReadChannel>("/Videos/{videoId}/{mediaSourceId}/Attachments/{index}",
				pathParameters, queryParameters, data)
		return response
	}

	/**
	 * Get video attachment.
	 *
	 * @param videoId Video ID.
	 * @param mediaSourceId Media Source ID.
	 * @param index Attachment Index.
	 * @param includeCredentials Add the access token to the url to make an authenticated request.
	 */
	public fun getAttachmentUrl(
		videoId: UUID,
		mediaSourceId: String,
		index: Int,
		includeCredentials: Boolean = false,
	): String {
		val pathParameters = buildMap<String, Any?>(3) {
			put("videoId", videoId)
			put("mediaSourceId", mediaSourceId)
			put("index", index)
		}
		val queryParameters = emptyMap<String, Any?>()
		return api.createUrl("/Videos/{videoId}/{mediaSourceId}/Attachments/{index}", pathParameters,
				queryParameters, includeCredentials)
	}
}
