/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import androidx.core.bundle.Bundle;
import androidx.lifecycle.Lifecycle;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavControllerViewModel;
import androidx.navigation.NavDestination;
import androidx.navigation.NavViewModelStoreProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0018"}, d2={"Landroidx/navigation/NavBackStackEntryState;", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "(Landroidx/navigation/NavBackStackEntry;)V", "args", "Landroidx/core/bundle/Bundle;", "getArgs", "()Landroidx/core/bundle/Bundle;", "destinationRoute", "", "getDestinationRoute", "()Ljava/lang/String;", "id", "getId", "savedState", "getSavedState", "instantiate", "destination", "Landroidx/navigation/NavDestination;", "hostLifecycleState", "Landroidx/lifecycle/Lifecycle$State;", "viewModel", "Landroidx/navigation/NavControllerViewModel;", "navigation-runtime"})
public final class NavBackStackEntryState {
    @NotNull
    private final String id;
    @NotNull
    private final String destinationRoute;
    @Nullable
    private final Bundle args;
    @NotNull
    private final Bundle savedState;

    public NavBackStackEntryState(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.id = entry.getId();
        String string = entry.getDestination().getRoute();
        Intrinsics.checkNotNull((Object)string);
        this.destinationRoute = string;
        this.args = entry.getArguments();
        this.savedState = new Bundle();
        entry.saveState(this.savedState);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getDestinationRoute() {
        return this.destinationRoute;
    }

    @Nullable
    public final Bundle getArgs() {
        return this.args;
    }

    @NotNull
    public final Bundle getSavedState() {
        return this.savedState;
    }

    @NotNull
    public final NavBackStackEntry instantiate(@NotNull NavDestination destination, @NotNull Lifecycle.State hostLifecycleState, @Nullable NavControllerViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)hostLifecycleState, (String)"hostLifecycleState");
        return NavBackStackEntry.Companion.create(destination, this.args, hostLifecycleState, (NavViewModelStoreProvider)viewModel, this.id, this.savedState);
    }
}

