/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.application.internal.MultiOutputStreamKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0002Jm\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u00042\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;", "", "verbose", "Lorg/gradle/api/provider/Property;", "", "logsDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Provider;Lorg/gradle/process/ExecOperations;)V", "currentTimeStamp", "", "kotlin.jvm.PlatformType", "invoke", "Lorg/gradle/process/ExecResult;", "tool", "Ljava/io/File;", "args", "", "environment", "", "workingDir", "checkExitCodeIsNormal", "processStdout", "Lkotlin/Function1;", "", "forceLogToFile", "compose"})
public final class ExternalToolRunner {
    @NotNull
    private final Property<Boolean> verbose;
    @NotNull
    private final Provider<Directory> logsDir;
    @NotNull
    private final ExecOperations execOperations;

    public ExternalToolRunner(@NotNull Property<Boolean> verbose, @NotNull Provider<Directory> logsDir, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter(verbose, (String)"verbose");
        Intrinsics.checkNotNullParameter(logsDir, (String)"logsDir");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.verbose = verbose;
        this.logsDir = logsDir;
        this.execOperations = execOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExecResult invoke(@NotNull File tool, @NotNull Collection<String> args2, @NotNull Map<String, ? extends Object> environment, @Nullable File workingDir, boolean checkExitCodeIsNormal, @Nullable Function1<? super String, Unit> processStdout, boolean forceLogToFile) {
        ExecResult execResult;
        Object object;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        File logsDir = GradleUtilsKt.getIoFile(this.logsDir);
        logsDir.mkdirs();
        String toolName = FilesKt.getNameWithoutExtension((File)tool);
        Object object2 = this.verbose.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"verbose.get()");
        boolean logToConsole = (Boolean)object2 != false && !forceLogToFile;
        File outFile = FilesKt.resolve((File)logsDir, (String)(toolName + '-' + this.currentTimeStamp() + "-out.txt"));
        File errFile = FilesKt.resolve((File)logsDir, (String)(toolName + '-' + this.currentTimeStamp() + "-err.txt"));
        Object object3 = outFile;
        int n = 0;
        object3 = new FileOutputStream((File)object3);
        n = 8192;
        boolean bl = false;
        object3 = object3 instanceof BufferedOutputStream ? (BufferedOutputStream)object3 : new BufferedOutputStream((OutputStream)object3, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedOutputStream outFileStream = (BufferedOutputStream)object3;
            boolean bl2 = false;
            Object object4 = errFile;
            int n2 = 0;
            object4 = new FileOutputStream((File)object4);
            n2 = 8192;
            boolean bl3 = false;
            object4 = object4 instanceof BufferedOutputStream ? (BufferedOutputStream)object4 : new BufferedOutputStream((OutputStream)object4, n2);
            n2 = 0;
            bl3 = false;
            serializable = null;
            try {
                BufferedOutputStream errFileStream = (BufferedOutputStream)object4;
                boolean bl4 = false;
                object = this.execOperations.exec(arg_0 -> ExternalToolRunner.invoke$lambda-3$lambda-2$lambda-1(tool, args2, workingDir, environment, logToConsole, outFileStream, errFileStream, arg_0));
            }
            catch (Throwable throwable2) {
                serializable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object4, (Throwable)serializable);
            }
            execResult = object;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
        }
        ExecResult result = execResult;
        if (checkExitCodeIsNormal && result.getExitValue() != 0) {
            n = 0;
            boolean bl5 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            StringBuilder $this$invoke_u24lambda_u2d4 = stringBuilder;
            boolean bl8 = false;
            serializable = $this$invoke_u24lambda_u2d4;
            object = "External tool execution failed:";
            boolean bl9 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)serializable).append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl10 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            String cmd = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)tool.getAbsolutePath()), (Iterable)args2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            object = $this$invoke_u24lambda_u2d4;
            Object object5 = "* Command: [" + cmd + ']';
            boolean bl11 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)object).append((String)object5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            object = $this$invoke_u24lambda_u2d4;
            StringBuilder stringBuilder6 = new StringBuilder().append("* Working dir: [");
            object5 = workingDir;
            object5 = object5 == null ? null : ((File)object5).getAbsolutePath();
            bl11 = false;
            Object object6 = object5;
            if (object6 == null) {
                object6 = "";
            }
            object5 = stringBuilder6.append((String)object6).append(']').toString();
            bl11 = false;
            StringBuilder stringBuilder7 = ((StringBuilder)object).append((String)object5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            stringBuilder5 = stringBuilder7;
            bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            object = $this$invoke_u24lambda_u2d4;
            object5 = Intrinsics.stringPlus((String)"* Exit code: ", (Object)result.getExitValue());
            bl11 = false;
            StringBuilder stringBuilder8 = ((StringBuilder)object).append((String)object5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            stringBuilder5 = stringBuilder8;
            bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            object = $this$invoke_u24lambda_u2d4;
            object5 = Intrinsics.stringPlus((String)"* Standard output log: ", (Object)outFile.getAbsolutePath());
            bl11 = false;
            StringBuilder stringBuilder9 = ((StringBuilder)object).append((String)object5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
            stringBuilder5 = stringBuilder9;
            bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            object = $this$invoke_u24lambda_u2d4;
            object5 = Intrinsics.stringPlus((String)"* Error log: ", (Object)errFile.getAbsolutePath());
            bl11 = false;
            StringBuilder stringBuilder10 = ((StringBuilder)object).append((String)object5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
            stringBuilder5 = stringBuilder10;
            bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String errMsg = string;
            n = 0;
            throw (Throwable)new IllegalStateException(errMsg.toString());
        }
        if (processStdout != null) {
            processStdout.invoke((Object)FilesKt.readText$default((File)outFile, null, (int)1, null));
        }
        if (result.getExitValue() == 0) {
            outFile.delete();
            errFile.delete();
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    public static /* synthetic */ ExecResult invoke$default(ExternalToolRunner externalToolRunner, File file, Collection collection, Map map, File file2, boolean bl, Function1 function1, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            file2 = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        return externalToolRunner.invoke(file, collection, map, file2, bl, (Function1<? super String, Unit>)function1, bl2);
    }

    private final String currentTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
    }

    private static final void invoke$lambda-3$lambda-2$lambda-1(File $tool, Collection $args, File $workingDir, Map $environment, boolean $logToConsole, BufferedOutputStream $outFileStream, BufferedOutputStream $errFileStream, ExecSpec spec) {
        Intrinsics.checkNotNullParameter((Object)$tool, (String)"$tool");
        Intrinsics.checkNotNullParameter((Object)$args, (String)"$args");
        Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
        Intrinsics.checkNotNullParameter((Object)$outFileStream, (String)"$outFileStream");
        Intrinsics.checkNotNullParameter((Object)$errFileStream, (String)"$errFileStream");
        spec.setExecutable($tool.getAbsolutePath());
        Collection $this$toTypedArray$iv = $args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = stringArray;
        spec.args((Object[])Arrays.copyOf(object, ((String[])object).length));
        object = $workingDir;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object wd = object2;
            boolean bl3 = false;
            spec.workingDir(wd);
        }
        spec.environment($environment);
        spec.setIgnoreExitValue(true);
        if ($logToConsole) {
            object = spec.getStandardOutput();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"spec.standardOutput");
            spec.setStandardOutput(MultiOutputStreamKt.alsoOutputTo((OutputStream)object, $outFileStream));
            object = spec.getErrorOutput();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"spec.errorOutput");
            spec.setErrorOutput(MultiOutputStreamKt.alsoOutputTo((OutputStream)object, $errFileStream));
        } else {
            spec.setStandardOutput((OutputStream)$outFileStream);
            spec.setErrorOutput((OutputStream)$errFileStream);
        }
    }
}

