/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.MacUtils;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSSigningSettings;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/MacSigner;", "", "settings", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "runExternalTool", "Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;", "(Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;)V", "getSettings", "()Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "signKey", "", "findCertificate", "certificates", "sign", "", "file", "Ljava/io/File;", "entitlements", "forceEntitlements", "", "unsign", "compose"})
public final class MacSigner {
    @NotNull
    private final ValidatedMacOSSigningSettings settings;
    @NotNull
    private final ExternalToolRunner runExternalTool;
    private String signKey;

    public MacSigner(@NotNull ValidatedMacOSSigningSettings settings, @NotNull ExternalToolRunner runExternalTool) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)runExternalTool, (String)"runExternalTool");
        this.settings = settings;
        this.runExternalTool = runExternalTool;
        Object[] objectArray = new String[5];
        objectArray[0] = "find-certificate";
        objectArray[1] = "-a";
        objectArray[2] = "-c";
        objectArray[3] = this.settings.getFullDeveloperID();
        File file = this.settings.getKeychain();
        objectArray[4] = file == null ? null : file.getAbsolutePath();
        ExternalToolRunner.invoke$default(this.runExternalTool, MacUtils.INSTANCE.getSecurity(), CollectionsKt.listOfNotNull((Object[])objectArray), null, null, false, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String stdout) {
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                signKey = this.findCertificate(stdout);
            }
        }, false, 92, null);
    }

    @NotNull
    public final ValidatedMacOSSigningSettings getSettings() {
        return this.settings;
    }

    public final void sign(@NotNull File file, @Nullable File entitlements, boolean forceEntitlements) {
        Object it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = new String[9];
        object[0] = "-vvvv";
        object[1] = "--timestamp";
        object[2] = "--options";
        object[3] = "runtime";
        object[4] = "--force";
        object[5] = "--prefix";
        object[6] = this.settings.getPrefix();
        object[7] = "--sign";
        Object object2 = this.signKey;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signKey");
            throw null;
        }
        object[8] = object2;
        ArrayList args2 = CollectionsKt.arrayListOf((Object[])object);
        object = this.settings.getKeychain();
        if (object != null) {
            object2 = object;
            bl2 = false;
            bl = false;
            it = object2;
            boolean bl3 = false;
            args2.add("--keychain");
            args2.add(((File)it).getAbsolutePath());
        }
        if ((forceEntitlements || Files.isExecutable(file.toPath())) && (object = entitlements) != null) {
            object2 = object;
            bl2 = false;
            bl = false;
            it = object2;
            boolean bl4 = false;
            args2.add("--entitlements");
            args2.add(((File)it).getAbsolutePath());
        }
        args2.add(file.getAbsolutePath());
        ExternalToolRunner.invoke$default(this.runExternalTool, MacUtils.INSTANCE.getCodesign(), args2, null, null, false, null, false, 124, null);
    }

    public static /* synthetic */ void sign$default(MacSigner macSigner2, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        macSigner2.sign(file, file2, bl);
    }

    public final void unsign(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new String[]{"-vvvv", "--remove-signature", file.getAbsolutePath()};
        List args2 = CollectionsKt.listOf((Object[])objectArray);
        ExternalToolRunner.invoke$default(this.runExternalTool, MacUtils.INSTANCE.getCodesign(), args2, null, null, false, null, false, 124, null);
    }

    private final String findCertificate(String certificates) {
        Pattern regex = Pattern.compile("\"alis\"<blob>=\"([^\"]+)\"");
        Matcher m = regex.matcher(certificates);
        if (!m.find()) {
            Object object = this.settings.getKeychain();
            String keychainPath = object == null ? null : ((File)object).getAbsolutePath();
            StringBuilder stringBuilder = new StringBuilder().append("Could not find certificate for '").append(this.settings.getIdentity()).append("' in keychain [");
            object = keychainPath;
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                object2 = "";
            }
            object = stringBuilder.append((String)object2).append(']').toString();
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        String result = m.group(1);
        if (m.find()) {
            String string = "Multiple matching certificates are found for '" + this.settings.getFullDeveloperID() + "'. Please specify keychain containing unique matching certificate.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }
}

