/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.RuntimeCompressionLevel;
import org.jetbrains.compose.desktop.application.internal.CliArgUtilsKt;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.application.internal.JavaRuntimeProperties;
import org.jetbrains.compose.desktop.application.tasks.AbstractJvmToolOperationTask;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u001e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0013\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006 "}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractJLinkTask;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractJvmToolOperationTask;", "()V", "compressionLevel", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/compose/desktop/application/dsl/RuntimeCompressionLevel;", "getCompressionLevel$compose", "()Lorg/gradle/api/provider/Property;", "includeAllModules", "", "getIncludeAllModules", "javaRuntimePropertiesFile", "Lorg/gradle/api/file/RegularFileProperty;", "getJavaRuntimePropertiesFile", "()Lorg/gradle/api/file/RegularFileProperty;", "modules", "Lorg/gradle/api/provider/ListProperty;", "", "getModules", "()Lorg/gradle/api/provider/ListProperty;", "noHeaderFiles", "getNoHeaderFiles$compose", "noManPages", "getNoManPages$compose", "stripDebug", "getStripDebug$compose", "stripNativeCommands", "getStripNativeCommands$compose", "makeArgs", "", "tmpDir", "Ljava/io/File;", "compose"})
public abstract class AbstractJLinkTask
extends AbstractJvmToolOperationTask {
    @NotNull
    private final ListProperty<String> modules;
    @NotNull
    private final Property<Boolean> includeAllModules;
    @NotNull
    private final RegularFileProperty javaRuntimePropertiesFile;
    @NotNull
    private final Property<Boolean> stripDebug;
    @NotNull
    private final Property<Boolean> noHeaderFiles;
    @NotNull
    private final Property<Boolean> noManPages;
    @NotNull
    private final Property<Boolean> stripNativeCommands;
    @NotNull
    private final Property<RuntimeCompressionLevel> compressionLevel;

    public AbstractJLinkTask() {
        super("jlink");
        ListProperty listProperty = this.getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objects.listProperty(String::class.java)");
        this.modules = listProperty;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty = false;
        Property property = $this$notNullProperty$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.includeAllModules = property;
        $this$notNullProperty$iv = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)$this$notNullProperty$iv, (String)"objects.fileProperty()");
        this.javaRuntimePropertiesFile = $this$notNullProperty$iv;
        $this$notNullProperty$iv = this.getObjects();
        Boolean defaultValue$iv = true;
        boolean $i$f$notNullProperty2 = false;
        Property property2 = $this$notNullProperty$iv.property(Boolean.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java).value(defaultValue)");
        this.stripDebug = property2;
        $this$notNullProperty$iv = this.getObjects();
        defaultValue$iv = true;
        $i$f$notNullProperty2 = false;
        property2 = $this$notNullProperty$iv.property(Boolean.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java).value(defaultValue)");
        this.noHeaderFiles = property2;
        $this$notNullProperty$iv = this.getObjects();
        defaultValue$iv = true;
        $i$f$notNullProperty2 = false;
        property2 = $this$notNullProperty$iv.property(Boolean.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java).value(defaultValue)");
        this.noManPages = property2;
        $this$notNullProperty$iv = this.getObjects();
        defaultValue$iv = true;
        $i$f$notNullProperty2 = false;
        property2 = $this$notNullProperty$iv.property(Boolean.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java).value(defaultValue)");
        this.stripNativeCommands = property2;
        ObjectFactory $this$nullableProperty$iv = this.getObjects();
        boolean $i$f$nullableProperty = false;
        Property property3 = $this$nullableProperty$iv.property(RuntimeCompressionLevel.class);
        if (property3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.desktop.application.internal.DslUtilsKt.nullableProperty?>");
        }
        this.compressionLevel = property3;
    }

    @Input
    @NotNull
    public final ListProperty<String> getModules() {
        return this.modules;
    }

    @Input
    @NotNull
    public final Property<Boolean> getIncludeAllModules() {
        return this.includeAllModules;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getJavaRuntimePropertiesFile() {
        return this.javaRuntimePropertiesFile;
    }

    @Input
    @NotNull
    public final Property<Boolean> getStripDebug$compose() {
        return this.stripDebug;
    }

    @Input
    @NotNull
    public final Property<Boolean> getNoHeaderFiles$compose() {
        return this.noHeaderFiles;
    }

    @Input
    @NotNull
    public final Property<Boolean> getNoManPages$compose() {
        return this.noManPages;
    }

    @Input
    @NotNull
    public final Property<Boolean> getStripNativeCommands$compose() {
        return this.stripNativeCommands;
    }

    @Input
    @Optional
    @NotNull
    public final Property<RuntimeCompressionLevel> getCompressionLevel$compose() {
        return this.compressionLevel;
    }

    @Override
    @NotNull
    protected List<String> makeArgs(@NotNull File tmpDir) {
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        List<String> list = super.makeArgs(tmpDir);
        boolean bl = false;
        boolean bl2 = false;
        List<String> $this$makeArgs_u24lambda_u2d1 = list;
        boolean bl3 = false;
        Object object = this.getIncludeAllModules().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeAllModules.get()");
        List<String> modulesToInclude = (Boolean)object != false ? JavaRuntimeProperties.Companion.readFromFile(GradleUtilsKt.getIoFile((Provider)this.getJavaRuntimePropertiesFile())).getAvailableModules() : (List<String>)this.getModules().get();
        Intrinsics.checkNotNullExpressionValue(modulesToInclude, (String)"modulesToInclude");
        Iterable $this$forEach$iv = modulesToInclude;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String m = (String)element$iv;
            boolean bl4 = false;
            CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--add-modules", m, null, 4, null);
        }
        CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--strip-debug", (Provider)this.getStripDebug$compose(), null, 4, null);
        CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--no-header-files", (Provider)this.getNoHeaderFiles$compose(), null, 4, null);
        CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--no-man-pages", (Provider)this.getNoManPages$compose(), null, 4, null);
        CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--strip-native-commands", (Provider)this.getStripNativeCommands$compose(), null, 4, null);
        object = (RuntimeCompressionLevel)((Object)this.getCompressionLevel$compose().getOrNull());
        CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--compress", object == null ? null : Integer.valueOf(((RuntimeCompressionLevel)((Object)object)).getId$compose()), null, 4, null);
        CliArgUtilsKt.cliArg$default((Collection)$this$makeArgs_u24lambda_u2d1, "--output", (Provider)this.getDestinationDir(), null, 4, null);
        return list;
    }
}

