/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AssistantDirection: ImageVector
    get() {
        if (_assistantDirection != null) {
            return _assistantDirection!!
        }
        _assistantDirection = materialIcon(name = "Filled.AssistantDirection") {
            materialPath {
                moveTo(14.0f, 10.0f)
                lineTo(9.0f, 10.0f)
                curveToRelative(-0.6f, 0.0f, -1.0f, 0.4f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.5f)
                lineToRelative(3.5f, -3.5f)
                lineTo(14.0f, 7.5f)
                lineTo(14.0f, 10.0f)
                close()
                moveTo(12.0f, 1.0f)
                curveTo(5.9f, 1.0f, 1.0f, 5.9f, 1.0f, 12.0f)
                reflectiveCurveToRelative(4.9f, 11.0f, 11.0f, 11.0f)
                reflectiveCurveToRelative(11.0f, -4.9f, 11.0f, -11.0f)
                reflectiveCurveTo(18.1f, 1.0f, 12.0f, 1.0f)
                close()
                moveTo(19.73f, 12.58f)
                lineToRelative(-7.19f, 7.22f)
                curveToRelative(-0.35f, 0.27f, -0.79f, 0.27f, -1.15f, 0.0f)
                lineTo(4.2f, 12.58f)
                curveToRelative(-0.27f, -0.36f, -0.27f, -0.8f, 0.0f, -1.16f)
                lineToRelative(7.19f, -7.22f)
                curveToRelative(0.35f, -0.27f, 0.79f, -0.27f, 1.15f, 0.0f)
                lineToRelative(7.19f, 7.22f)
                curveToRelative(0.36f, 0.27f, 0.36f, 0.8f, 0.0f, 1.16f)
                close()
            }
        }
        return _assistantDirection!!
    }

private var _assistantDirection: ImageVector? = null
