/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FollowTheSigns: ImageVector
    get() {
        if (_followTheSigns != null) {
            return _followTheSigns!!
        }
        _followTheSigns = materialIcon(name = "Filled.FollowTheSigns") {
            materialPath {
                moveTo(9.5f, 5.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(8.4f, 5.5f, 9.5f, 5.5f)
                close()
                moveTo(5.75f, 8.9f)
                lineTo(3.0f, 23.0f)
                horizontalLineToRelative(2.1f)
                lineToRelative(1.75f, -8.0f)
                lineTo(9.0f, 17.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.55f)
                lineTo(8.95f, 13.4f)
                lineToRelative(0.6f, -3.0f)
                curveTo(10.85f, 12.0f, 12.8f, 13.0f, 15.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-1.85f, 0.0f, -3.45f, -1.0f, -4.35f, -2.45f)
                lineTo(9.7f, 6.95f)
                curveTo(9.35f, 6.35f, 8.7f, 6.0f, 8.0f, 6.0f)
                curveTo(7.75f, 6.0f, 7.5f, 6.05f, 7.25f, 6.15f)
                lineTo(2.0f, 8.3f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.65f)
                lineTo(5.75f, 8.9f)
                moveTo(13.0f, 2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(3.75f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(13.0f)
                close()
                moveTo(18.01f, 8.0f)
                verticalLineTo(6.25f)
                horizontalLineTo(14.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(3.51f)
                verticalLineTo(3.0f)
                lineToRelative(2.49f, 2.5f)
                lineTo(18.01f, 8.0f)
                close()
            }
        }
        return _followTheSigns!!
    }

private var _followTheSigns: ImageVector? = null
