/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.LabelOff: ImageVector
    get() {
        if (_labelOff != null) {
            return _labelOff!!
        }
        _labelOff = materialIcon(name = "Filled.LabelOff") {
            materialPath {
                moveTo(3.25f, 2.75f)
                lineToRelative(17.0f, 17.0f)
                lineTo(19.0f, 21.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.55f, 0.23f, -1.05f, 0.59f, -1.41f)
                lineTo(2.0f, 4.0f)
                lineToRelative(1.25f, -1.25f)
                close()
                moveTo(22.0f, 12.0f)
                lineToRelative(-4.37f, -6.16f)
                curveTo(17.27f, 5.33f, 16.67f, 5.0f, 16.0f, 5.0f)
                horizontalLineTo(8.0f)
                lineToRelative(11.0f, 11.0f)
                lineToRelative(3.0f, -4.0f)
                close()
            }
        }
        return _labelOff!!
    }

private var _labelOff: ImageVector? = null
