/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MovieFilter: ImageVector
    get() {
        if (_movieFilter != null) {
            return _movieFilter!!
        }
        _movieFilter = materialIcon(name = "Filled.MovieFilter") {
            materialPath {
                moveTo(18.0f, 4.0f)
                lineToRelative(2.0f, 3.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(-2.0f, -3.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(2.0f, 3.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(-2.0f, -3.0f)
                lineTo(8.0f, 4.0f)
                lineToRelative(2.0f, 3.0f)
                lineTo(7.0f, 7.0f)
                lineTo(5.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -1.99f, 0.9f, -1.99f, 2.0f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(22.0f, 4.0f)
                horizontalLineToRelative(-4.0f)
                close()
                moveTo(11.25f, 15.25f)
                lineTo(10.0f, 18.0f)
                lineToRelative(-1.25f, -2.75f)
                lineTo(6.0f, 14.0f)
                lineToRelative(2.75f, -1.25f)
                lineTo(10.0f, 10.0f)
                lineToRelative(1.25f, 2.75f)
                lineTo(14.0f, 14.0f)
                lineToRelative(-2.75f, 1.25f)
                close()
                moveTo(16.94f, 11.94f)
                lineTo(16.0f, 14.0f)
                lineToRelative(-0.94f, -2.06f)
                lineTo(13.0f, 11.0f)
                lineToRelative(2.06f, -0.94f)
                lineTo(16.0f, 8.0f)
                lineToRelative(0.94f, 2.06f)
                lineTo(19.0f, 11.0f)
                lineToRelative(-2.06f, 0.94f)
                close()
            }
        }
        return _movieFilter!!
    }

private var _movieFilter: ImageVector? = null
