/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NoDrinks: ImageVector
    get() {
        if (_noDrinks != null) {
            return _noDrinks!!
        }
        _noDrinks = materialIcon(name = "Filled.NoDrinks") {
            materialPath {
                moveTo(5.83f, 3.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(-6.2f, 6.97f)
                lineTo(9.83f, 7.0f)
                horizontalLineToRelative(6.74f)
                lineToRelative(1.78f, -2.0f)
                horizontalLineTo(7.83f)
                lineTo(5.83f, 3.0f)
                close()
                moveTo(19.78f, 22.61f)
                lineTo(18.0f, 20.83f)
                verticalLineTo(21.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-5.0f)
                lineToRelative(-1.37f, -1.54f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.0f, 3.0f)
                lineToRelative(18.19f, 18.19f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(16.17f, 19.0f)
                lineTo(13.0f, 15.83f)
                verticalLineTo(19.0f)
                horizontalLineTo(16.17f)
                close()
            }
        }
        return _noDrinks!!
    }

private var _noDrinks: ImageVector? = null
