/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NoEncryptionGmailerrorred: ImageVector
    get() {
        if (_noEncryptionGmailerrorred != null) {
            return _noEncryptionGmailerrorred!!
        }
        _noEncryptionGmailerrorred = materialIcon(name = "Filled.NoEncryptionGmailerrorred") {
            materialPath {
                moveTo(8.9f, 6.0f)
                curveToRelative(0.0f, -1.71f, 1.39f, -3.1f, 3.1f, -3.1f)
                reflectiveCurveToRelative(3.1f, 1.39f, 3.1f, 3.1f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.27f)
                lineTo(20.0f, 17.17f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                curveTo(9.79f, 1.0f, 7.93f, 2.45f, 7.27f, 4.44f)
                lineTo(8.9f, 6.07f)
                verticalLineTo(6.0f)
                close()
                moveTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineTo(5.3f, 8.13f)
                curveTo(4.55f, 8.42f, 4.0f, 9.15f, 4.0f, 10.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(0.34f, 0.0f, 0.65f, -0.09f, 0.93f, -0.24f)
                lineToRelative(1.56f, 1.56f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.1f, 2.1f)
                close()
                moveTo(12.0f, 17.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -0.59f, 0.27f, -1.12f, 0.68f, -1.49f)
                lineToRelative(2.81f, 2.81f)
                curveTo(13.12f, 16.73f, 12.59f, 17.0f, 12.0f, 17.0f)
                close()
            }
        }
        return _noEncryptionGmailerrorred!!
    }

private var _noEncryptionGmailerrorred: ImageVector? = null
