/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.OfflineShare: ImageVector
    get() {
        if (_offlineShare != null) {
            return _offlineShare!!
        }
        _offlineShare = materialIcon(name = "Filled.OfflineShare") {
            materialPath {
                moveTo(14.6f, 10.26f)
                verticalLineToRelative(1.31f)
                lineTo(17.0f, 9.33f)
                lineTo(14.6f, 7.1f)
                verticalLineToRelative(1.28f)
                curveToRelative(-2.33f, 0.32f, -3.26f, 1.92f, -3.6f, 3.52f)
                curveToRelative(0.83f, -1.13f, 1.93f, -1.64f, 3.6f, -1.64f)
                close()
                moveTo(16.0f, 23.0f)
                lineTo(6.0f, 23.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                lineTo(4.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(18.0f, 1.0f)
                horizontalLineToRelative(-8.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(20.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(18.0f, 16.0f)
                horizontalLineToRelative(-8.0f)
                lineTo(10.0f, 4.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(12.0f)
                close()
            }
        }
        return _offlineShare!!
    }

private var _offlineShare: ImageVector? = null
