/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.WindPower: ImageVector
    get() {
        if (_windPower != null) {
            return _windPower!!
        }
        _windPower = materialIcon(name = "Filled.WindPower") {
            materialPath {
                moveTo(4.0f, 3.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
            materialPath {
                moveTo(1.0f, 7.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 19.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(13.73f, 10.61f)
                curveToRelative(0.75f, 0.23f, 1.3f, 0.78f, 1.57f, 1.46f)
                lineToRelative(4.27f, -7.11f)
                curveToRelative(0.65f, -1.08f, 0.3f, -2.48f, -0.78f, -3.13f)
                curveToRelative(-0.87f, -0.52f, -1.99f, -0.41f, -2.73f, 0.29f)
                lineToRelative(-3.43f, 3.21f)
                curveTo(12.23f, 5.7f, 12.0f, 6.23f, 12.0f, 6.78f)
                verticalLineToRelative(3.93f)
                curveTo(12.36f, 10.56f, 12.98f, 10.38f, 13.73f, 10.61f)
                close()
            }
            materialPath {
                moveTo(10.61f, 12.27f)
                curveToRelative(0.16f, -0.52f, 0.48f, -0.96f, 0.89f, -1.27f)
                horizontalLineTo(3.28f)
                curveTo(2.02f, 11.0f, 1.0f, 12.02f, 1.0f, 13.28f)
                curveToRelative(0.0f, 1.02f, 0.67f, 1.91f, 1.65f, 2.19f)
                lineToRelative(4.51f, 1.29f)
                curveToRelative(0.53f, 0.15f, 1.1f, 0.08f, 1.58f, -0.21f)
                lineToRelative(2.69f, -1.61f)
                curveTo(10.66f, 14.32f, 10.3f, 13.27f, 10.61f, 12.27f)
                close()
            }
            materialPath {
                moveTo(22.21f, 18.61f)
                lineToRelative(-2.28f, -4.1f)
                curveToRelative(-0.27f, -0.48f, -0.73f, -0.83f, -1.26f, -0.97f)
                lineToRelative(-3.18f, -0.8f)
                curveToRelative(0.03f, 0.32f, 0.0f, 0.66f, -0.1f, 0.99f)
                curveToRelative(-0.32f, 1.06f, -1.28f, 1.77f, -2.39f, 1.77f)
                curveToRelative(-0.61f, 0.0f, -0.99f, -0.22f, -1.0f, -0.22f)
                verticalLineTo(21.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                verticalLineToRelative(-4.28f)
                lineToRelative(4.61f, 4.61f)
                curveToRelative(0.89f, 0.89f, 2.33f, 0.89f, 3.22f, 0.0f)
                curveTo(22.55f, 20.61f, 22.71f, 19.5f, 22.21f, 18.61f)
                close()
            }
            materialPath {
                moveTo(12.56f, 14.43f)
                curveToRelative(0.79f, 0.24f, 1.63f, -0.2f, 1.87f, -1.0f)
                curveToRelative(0.24f, -0.79f, -0.2f, -1.63f, -1.0f, -1.87f)
                curveToRelative(-0.79f, -0.24f, -1.63f, 0.2f, -1.87f, 1.0f)
                curveTo(11.32f, 13.35f, 11.77f, 14.19f, 12.56f, 14.43f)
                close()
            }
        }
        return _windPower!!
    }

private var _windPower: ImageVector? = null
