/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Discount: ImageVector
    get() {
        if (_discount != null) {
            return _discount!!
        }
        _discount = materialIcon(name = "Outlined.Discount") {
            materialPath {
                moveTo(12.79f, 21.0f)
                lineTo(3.0f, 11.21f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.53f, 0.21f, 1.04f, 0.59f, 1.41f)
                lineToRelative(7.79f, 7.79f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(6.21f, -6.21f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineTo(12.79f, 21.0f)
                close()
            }
            materialPath {
                moveTo(11.38f, 17.41f)
                curveToRelative(0.39f, 0.39f, 0.9f, 0.59f, 1.41f, 0.59f)
                curveToRelative(0.51f, 0.0f, 1.02f, -0.2f, 1.41f, -0.59f)
                lineToRelative(6.21f, -6.21f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-7.79f, -7.79f)
                curveTo(12.25f, 0.21f, 11.74f, 0.0f, 11.21f, 0.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 0.0f, 3.0f, 0.9f, 3.0f, 2.0f)
                verticalLineToRelative(6.21f)
                curveToRelative(0.0f, 0.53f, 0.21f, 1.04f, 0.59f, 1.41f)
                lineTo(11.38f, 17.41f)
                close()
                moveTo(5.0f, 2.0f)
                horizontalLineToRelative(6.21f)
                lineTo(19.0f, 9.79f)
                lineTo(12.79f, 16.0f)
                lineTo(5.0f, 8.21f)
                verticalLineTo(2.0f)
                close()
            }
            materialPath {
                moveTo(7.25f, 4.25f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
        }
        return _discount!!
    }

private var _discount: ImageVector? = null
