/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Gif: ImageVector
    get() {
        if (_gif != null) {
            return _gif!!
        }
        _gif = materialIcon(name = "Outlined.Gif") {
            materialPath {
                moveTo(11.5f, 9.0f)
                lineTo(13.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(11.5f, 9.0f)
                close()
                moveTo(9.0f, 9.0f)
                lineTo(6.0f, 9.0f)
                curveToRelative(-0.6f, 0.0f, -1.0f, 0.5f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.5f, 0.4f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.6f, 0.0f, 1.0f, -0.5f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                lineTo(8.5f, 12.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                lineTo(10.0f, 10.5f)
                lineTo(10.0f, 10.0f)
                curveToRelative(0.0f, -0.5f, -0.4f, -1.0f, -1.0f, -1.0f)
                close()
                moveTo(19.0f, 10.5f)
                lineTo(19.0f, 9.0f)
                horizontalLineToRelative(-4.5f)
                verticalLineToRelative(6.0f)
                lineTo(16.0f, 15.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(3.0f)
                close()
            }
        }
        return _gif!!
    }

private var _gif: ImageVector? = null
