/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ImageNotSupported: ImageVector
    get() {
        if (_imageNotSupported != null) {
            return _imageNotSupported!!
        }
        _imageNotSupported = materialIcon(name = "Outlined.ImageNotSupported") {
            materialPath {
                moveTo(21.9f, 21.9f)
                lineToRelative(-6.1f, -6.1f)
                lineToRelative(-2.69f, -2.69f)
                lineToRelative(0.0f, 0.0f)
                lineTo(5.0f, 5.0f)
                lineToRelative(0.0f, 0.0f)
                lineTo(3.59f, 3.59f)
                lineToRelative(0.0f, 0.0f)
                lineTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineTo(3.0f, 5.83f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(2.31f, 2.31f)
                lineTo(21.9f, 21.9f)
                close()
                moveTo(5.0f, 19.0f)
                verticalLineTo(7.83f)
                lineToRelative(6.84f, 6.84f)
                lineTo(11.0f, 15.72f)
                lineTo(9.0f, 13.0f)
                lineToRelative(-3.0f, 4.0f)
                horizontalLineToRelative(8.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(5.0f)
                close()
                moveTo(7.83f, 5.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(19.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(13.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(7.83f)
                close()
            }
        }
        return _imageNotSupported!!
    }

private var _imageNotSupported: ImageVector? = null
