/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MissedVideoCall: ImageVector
    get() {
        if (_missedVideoCall != null) {
            return _missedVideoCall!!
        }
        _missedVideoCall = materialIcon(name = "Outlined.MissedVideoCall") {
            materialPath {
                moveTo(17.0f, 10.5f)
                lineTo(17.0f, 7.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(4.0f, 6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.5f)
                lineToRelative(4.0f, 4.0f)
                verticalLineToRelative(-11.0f)
                lineToRelative(-4.0f, 4.0f)
                close()
                moveTo(15.0f, 8.67f)
                lineTo(15.0f, 16.0f)
                lineTo(5.0f, 16.0f)
                lineTo(5.0f, 8.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(0.67f)
                close()
                moveTo(7.11f, 11.11f)
                lineTo(11.0f, 15.0f)
                lineToRelative(3.77f, -3.79f)
                lineToRelative(-0.78f, -0.79f)
                lineTo(11.0f, 13.43f)
                lineToRelative(-3.11f, -3.1f)
                horizontalLineToRelative(2.55f)
                lineTo(10.44f, 9.22f)
                lineTo(6.0f, 9.22f)
                verticalLineToRelative(4.44f)
                horizontalLineToRelative(1.11f)
                close()
            }
        }
        return _missedVideoCall!!
    }

private var _missedVideoCall: ImageVector? = null
