/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ReduceCapacity: ImageVector
    get() {
        if (_reduceCapacity != null) {
            return _reduceCapacity!!
        }
        _reduceCapacity = materialIcon(name = "Outlined.ReduceCapacity") {
            materialPath {
                moveTo(16.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(16.0f, 5.1f, 16.0f, 4.0f)
                close()
                moveTo(20.78f, 7.58f)
                curveTo(19.93f, 7.21f, 18.99f, 7.0f, 18.0f, 7.0f)
                curveToRelative(-0.67f, 0.0f, -1.31f, 0.1f, -1.92f, 0.28f)
                curveTo(16.66f, 7.83f, 17.0f, 8.6f, 17.0f, 9.43f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(9.43f)
                curveTo(22.0f, 8.62f, 21.52f, 7.9f, 20.78f, 7.58f)
                close()
                moveTo(6.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(7.1f, 2.0f, 6.0f, 2.0f)
                reflectiveCurveTo(4.0f, 2.9f, 4.0f, 4.0f)
                reflectiveCurveTo(4.9f, 6.0f, 6.0f, 6.0f)
                close()
                moveTo(7.92f, 7.28f)
                curveTo(7.31f, 7.1f, 6.67f, 7.0f, 6.0f, 7.0f)
                curveTo(5.01f, 7.0f, 4.07f, 7.21f, 3.22f, 7.58f)
                curveTo(2.48f, 7.9f, 2.0f, 8.62f, 2.0f, 9.43f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(9.43f)
                curveTo(7.0f, 8.6f, 7.34f, 7.83f, 7.92f, 7.28f)
                close()
                moveTo(10.0f, 4.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(10.0f, 5.1f, 10.0f, 4.0f)
                close()
                moveTo(16.0f, 10.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(9.43f)
                curveTo(8.0f, 8.62f, 8.48f, 7.9f, 9.22f, 7.58f)
                curveTo(10.07f, 7.21f, 11.01f, 7.0f, 12.0f, 7.0f)
                curveToRelative(0.99f, 0.0f, 1.93f, 0.21f, 2.78f, 0.58f)
                curveTo(15.52f, 7.9f, 16.0f, 8.62f, 16.0f, 9.43f)
                verticalLineTo(10.0f)
                close()
                moveTo(15.0f, 16.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(15.0f, 17.1f, 15.0f, 16.0f)
                close()
                moveTo(21.0f, 22.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(-0.57f)
                curveToRelative(0.0f, -0.81f, 0.48f, -1.53f, 1.22f, -1.85f)
                curveTo(15.07f, 19.21f, 16.01f, 19.0f, 17.0f, 19.0f)
                curveToRelative(0.99f, 0.0f, 1.93f, 0.21f, 2.78f, 0.58f)
                curveTo(20.52f, 19.9f, 21.0f, 20.62f, 21.0f, 21.43f)
                verticalLineTo(22.0f)
                close()
                moveTo(5.0f, 16.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(5.0f, 17.1f, 5.0f, 16.0f)
                close()
                moveTo(11.0f, 22.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-0.57f)
                curveToRelative(0.0f, -0.81f, 0.48f, -1.53f, 1.22f, -1.85f)
                curveTo(5.07f, 19.21f, 6.01f, 19.0f, 7.0f, 19.0f)
                curveToRelative(0.99f, 0.0f, 1.93f, 0.21f, 2.78f, 0.58f)
                curveTo(10.52f, 19.9f, 11.0f, 20.62f, 11.0f, 21.43f)
                verticalLineTo(22.0f)
                close()
                moveTo(12.75f, 13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(9.0f)
                lineToRelative(3.0f, 3.0f)
                lineToRelative(3.0f, -3.0f)
                horizontalLineTo(12.75f)
                close()
            }
        }
        return _reduceCapacity!!
    }

private var _reduceCapacity: ImageVector? = null
