/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SatelliteAlt: ImageVector
    get() {
        if (_satelliteAlt != null) {
            return _satelliteAlt!!
        }
        _satelliteAlt = materialIcon(name = "Outlined.SatelliteAlt") {
            materialPath {
                moveTo(21.0f, 14.0f)
                lineToRelative(2.0f, 0.0f)
                curveToRelative(0.0f, 4.97f, -4.03f, 9.0f, -9.0f, 9.0f)
                lineToRelative(0.0f, -2.0f)
                curveTo(17.87f, 21.0f, 21.0f, 17.87f, 21.0f, 14.0f)
                close()
                moveTo(14.0f, 17.0f)
                lineToRelative(0.0f, 2.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                lineToRelative(-2.0f, 0.0f)
                curveTo(17.0f, 15.66f, 15.66f, 17.0f, 14.0f, 17.0f)
                close()
                moveTo(18.26f, 0.59f)
                lineToRelative(3.54f, 3.54f)
                curveToRelative(0.78f, 0.78f, 0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(-3.18f, 3.18f)
                curveToRelative(-0.78f, 0.78f, -2.05f, 0.78f, -2.83f, 0.0f)
                lineToRelative(-1.24f, -1.24f)
                lineTo(13.84f, 9.6f)
                lineToRelative(1.24f, 1.24f)
                curveToRelative(0.78f, 0.78f, 0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(-1.41f, 1.41f)
                curveToRelative(-0.78f, 0.78f, -2.05f, 0.78f, -2.83f, 0.0f)
                lineTo(9.6f, 13.84f)
                lineToRelative(-0.71f, 0.71f)
                lineToRelative(1.24f, 1.24f)
                curveToRelative(0.78f, 0.78f, 0.78f, 2.05f, 0.0f, 2.83f)
                lineTo(6.95f, 21.8f)
                curveToRelative(-0.78f, 0.78f, -2.05f, 0.78f, -2.83f, 0.0f)
                lineToRelative(-3.54f, -3.54f)
                curveToRelative(-0.78f, -0.78f, -0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(3.18f, -3.18f)
                curveToRelative(0.78f, -0.78f, 2.05f, -0.78f, 2.83f, 0.0f)
                lineToRelative(1.24f, 1.24f)
                lineToRelative(0.71f, -0.71f)
                lineTo(7.3f, 11.55f)
                curveToRelative(-0.78f, -0.78f, -0.78f, -2.05f, 0.0f, -2.83f)
                lineTo(8.72f, 7.3f)
                curveToRelative(0.78f, -0.78f, 2.05f, -0.78f, 2.83f, 0.0f)
                lineToRelative(1.24f, 1.24f)
                lineToRelative(0.71f, -0.71f)
                lineTo(12.25f, 6.6f)
                curveToRelative(-0.78f, -0.78f, -0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(3.18f, -3.18f)
                curveTo(16.22f, -0.2f, 17.48f, -0.2f, 18.26f, 0.59f)
                close()
                moveTo(3.06f, 15.79f)
                lineTo(2.0f, 16.85f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(3.06f, 15.79f)
                close()
                moveTo(5.18f, 13.67f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(5.18f, 13.67f)
                close()
                moveTo(10.13f, 8.72f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(1.41f, -1.41f)
                lineTo(10.13f, 8.72f)
                close()
                moveTo(14.73f, 4.12f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(14.73f, 4.12f)
                close()
                moveTo(16.85f, 2.0f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(16.85f, 2.0f)
                close()
            }
        }
        return _satelliteAlt!!
    }

private var _satelliteAlt: ImageVector? = null
