/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Tapas: ImageVector
    get() {
        if (_tapas != null) {
            return _tapas!!
        }
        _tapas = materialIcon(name = "Outlined.Tapas") {
            materialPath {
                moveTo(22.0f, 10.0f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.86f, 1.28f, 3.41f, 3.0f, 3.86f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-7.14f)
                curveTo(20.72f, 13.41f, 22.0f, 11.86f, 22.0f, 10.0f)
                close()
                moveTo(20.0f, 3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(16.0f, 10.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(16.0f, 11.1f, 16.0f, 10.0f)
                close()
                moveTo(10.0f, 9.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveTo(12.5f, 4.12f, 11.38f, 3.0f, 10.0f, 3.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(1.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.62f, 3.0f, 1.5f, 4.12f, 1.5f, 5.5f)
                curveTo(1.5f, 6.88f, 2.62f, 8.0f, 4.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, 1.12f, -2.5f, 2.5f)
                curveTo(1.5f, 12.88f, 2.62f, 14.0f, 4.0f, 14.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-9.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveTo(12.5f, 10.12f, 11.38f, 9.0f, 10.0f, 9.0f)
                close()
                moveTo(4.0f, 6.0f)
                curveTo(3.72f, 6.0f, 3.5f, 5.78f, 3.5f, 5.5f)
                reflectiveCurveTo(3.72f, 5.0f, 4.0f, 5.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                reflectiveCurveTo(10.28f, 6.0f, 10.0f, 6.0f)
                horizontalLineTo(4.0f)
                close()
                moveTo(10.0f, 12.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                reflectiveCurveTo(3.72f, 11.0f, 4.0f, 11.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                reflectiveCurveTo(10.28f, 12.0f, 10.0f, 12.0f)
                close()
            }
        }
        return _tapas!!
    }

private var _tapas: ImageVector? = null
