/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ThumbsUpDown: ImageVector
    get() {
        if (_thumbsUpDown != null) {
            return _thumbsUpDown!!
        }
        _thumbsUpDown = materialIcon(name = "Outlined.ThumbsUpDown") {
            materialPath {
                moveTo(12.0f, 6.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(5.82f, 5.0f)
                lineToRelative(0.66f, -3.18f)
                lineToRelative(0.02f, -0.23f)
                curveToRelative(0.0f, -0.31f, -0.13f, -0.59f, -0.33f, -0.8f)
                lineTo(5.38f, 0.0f)
                lineTo(0.44f, 4.94f)
                curveTo(0.17f, 5.21f, 0.0f, 5.59f, 0.0f, 6.0f)
                verticalLineToRelative(6.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineToRelative(6.75f)
                curveToRelative(0.62f, 0.0f, 1.15f, -0.38f, 1.38f, -0.91f)
                lineToRelative(2.26f, -5.29f)
                curveToRelative(0.07f, -0.17f, 0.11f, -0.36f, 0.11f, -0.55f)
                lineTo(12.0f, 6.0f)
                close()
                moveTo(10.0f, 7.13f)
                lineTo(7.92f, 12.0f)
                lineTo(2.0f, 12.0f)
                lineTo(2.0f, 6.21f)
                lineToRelative(1.93f, -1.93f)
                lineTo(3.36f, 7.0f)
                lineTo(10.0f, 7.0f)
                verticalLineToRelative(0.13f)
                close()
                moveTo(22.5f, 10.0f)
                horizontalLineToRelative(-6.75f)
                curveToRelative(-0.62f, 0.0f, -1.15f, 0.38f, -1.38f, 0.91f)
                lineToRelative(-2.26f, 5.29f)
                curveToRelative(-0.07f, 0.17f, -0.11f, 0.36f, -0.11f, 0.55f)
                lineTo(12.0f, 18.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(5.18f)
                lineToRelative(-0.66f, 3.18f)
                lineToRelative(-0.02f, 0.24f)
                curveToRelative(0.0f, 0.31f, 0.13f, 0.59f, 0.33f, 0.8f)
                lineToRelative(0.79f, 0.78f)
                lineToRelative(4.94f, -4.94f)
                curveToRelative(0.27f, -0.27f, 0.44f, -0.65f, 0.44f, -1.06f)
                verticalLineToRelative(-6.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                close()
                moveTo(22.0f, 17.79f)
                lineToRelative(-1.93f, 1.93f)
                lineToRelative(0.57f, -2.72f)
                lineTo(14.0f, 17.0f)
                verticalLineToRelative(-0.13f)
                lineTo(16.08f, 12.0f)
                lineTo(22.0f, 12.0f)
                verticalLineToRelative(5.79f)
                close()
            }
        }
        return _thumbsUpDown!!
    }

private var _thumbsUpDown: ImageVector? = null
