/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BedroomParent: ImageVector
    get() {
        if (_bedroomParent != null) {
            return _bedroomParent!!
        }
        _bedroomParent = materialIcon(name = "Rounded.BedroomParent") {
            materialPath {
                moveTo(16.5f, 12.0f)
                horizontalLineToRelative(-9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(-1.0f)
                curveTo(17.5f, 12.45f, 17.05f, 12.0f, 16.5f, 12.0f)
                close()
            }
            materialPath {
                moveTo(7.25f, 8.5f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(12.75f, 8.5f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(18.25f, 17.0f)
                lineTo(18.25f, 17.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineTo(15.5f)
                horizontalLineToRelative(-11.0f)
                verticalLineToRelative(0.75f)
                curveTo(6.5f, 16.66f, 6.16f, 17.0f, 5.75f, 17.0f)
                horizontalLineToRelative(0.0f)
                curveTo(5.34f, 17.0f, 5.0f, 16.66f, 5.0f, 16.25f)
                verticalLineToRelative(-3.08f)
                curveToRelative(0.0f, -0.66f, 0.25f, -1.26f, 0.65f, -1.72f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineTo(11.0f)
                curveToRelative(0.37f, 0.0f, 0.72f, 0.12f, 1.0f, 0.32f)
                curveTo(12.28f, 7.12f, 12.63f, 7.0f, 13.0f, 7.0f)
                horizontalLineToRelative(3.35f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(2.45f)
                curveToRelative(0.4f, 0.46f, 0.65f, 1.06f, 0.65f, 1.72f)
                verticalLineToRelative(3.08f)
                curveTo(19.0f, 16.66f, 18.66f, 17.0f, 18.25f, 17.0f)
                close()
            }
        }
        return _bedroomParent!!
    }

private var _bedroomParent: ImageVector? = null
