/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Crib: ImageVector
    get() {
        if (_crib != null) {
            return _crib!!
        }
        _crib = materialIcon(name = "Rounded.Crib") {
            materialPath {
                moveTo(18.32f, 18.32f)
                curveToRelative(-0.36f, -0.36f, -0.92f, -0.4f, -1.31f, -0.08f)
                curveToRelative(-0.32f, 0.25f, -0.65f, 0.48f, -1.0f, 0.69f)
                verticalLineTo(16.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(8.0f)
                curveTo(5.79f, 4.0f, 4.0f, 5.79f, 4.0f, 8.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.93f)
                curveToRelative(-0.35f, -0.2f, -0.69f, -0.43f, -1.0f, -0.69f)
                curveToRelative(-0.39f, -0.32f, -0.96f, -0.27f, -1.31f, 0.08f)
                curveToRelative(-0.42f, 0.42f, -0.39f, 1.12f, 0.08f, 1.5f)
                curveTo(7.47f, 21.18f, 9.64f, 22.0f, 12.0f, 22.0f)
                curveToRelative(2.36f, 0.0f, 4.53f, -0.82f, 6.24f, -2.18f)
                curveTo(18.71f, 19.44f, 18.74f, 18.74f, 18.32f, 18.32f)
                close()
                moveTo(14.0f, 19.75f)
                curveTo(13.36f, 19.91f, 12.69f, 20.0f, 12.0f, 20.0f)
                curveToRelative(-0.69f, 0.0f, -1.36f, -0.09f, -2.0f, -0.25f)
                verticalLineTo(16.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(19.75f)
                close()
            }
        }
        return _crib!!
    }

private var _crib: ImageVector? = null
