/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FileDownloadOff: ImageVector
    get() {
        if (_fileDownloadOff != null) {
            return _fileDownloadOff!!
        }
        _fileDownloadOff = materialIcon(name = "Rounded.FileDownloadOff") {
            materialPath {
                moveTo(9.0f, 6.17f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(1.59f)
                curveToRelative(0.89f, 0.0f, 1.33f, 1.08f, 0.7f, 1.71f)
                lineToRelative(-1.88f, 1.88f)
                lineTo(9.0f, 6.17f)
                close()
                moveTo(20.49f, 20.49f)
                lineTo(3.51f, 3.51f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(4.5f, 4.5f)
                curveToRelative(-0.26f, 0.37f, -0.28f, 0.91f, 0.1f, 1.28f)
                lineToRelative(4.59f, 4.59f)
                curveToRelative(0.35f, 0.35f, 0.88f, 0.37f, 1.27f, 0.09f)
                lineTo(15.17f, 18.0f)
                horizontalLineTo(6.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(11.17f)
                lineToRelative(1.9f, 1.9f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveTo(20.88f, 21.51f, 20.88f, 20.88f, 20.49f, 20.49f)
                close()
            }
        }
        return _fileDownloadOff!!
    }

private var _fileDownloadOff: ImageVector? = null
