/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.GeneratingTokens: ImageVector
    get() {
        if (_generatingTokens != null) {
            return _generatingTokens!!
        }
        _generatingTokens = materialIcon(name = "Rounded.GeneratingTokens") {
            materialPath {
                moveTo(9.0f, 4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                curveToRelative(0.0f, 4.42f, 3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                curveTo(17.0f, 7.58f, 13.42f, 4.0f, 9.0f, 4.0f)
                close()
                moveTo(9.0f, 15.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(6.75f)
                curveTo(6.34f, 10.5f, 6.0f, 10.16f, 6.0f, 9.75f)
                reflectiveCurveTo(6.34f, 9.0f, 6.75f, 9.0f)
                horizontalLineToRelative(4.5f)
                curveTo(11.66f, 9.0f, 12.0f, 9.34f, 12.0f, 9.75f)
                reflectiveCurveToRelative(-0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(4.0f)
                curveTo(10.0f, 15.05f, 9.55f, 15.5f, 9.0f, 15.5f)
                close()
                moveTo(20.25f, 3.75f)
                lineTo(22.0f, 4.54f)
                curveToRelative(0.39f, 0.18f, 0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(-1.75f, 0.79f)
                lineTo(19.46f, 8.0f)
                curveToRelative(-0.18f, 0.39f, -0.73f, 0.39f, -0.91f, 0.0f)
                lineToRelative(-0.79f, -1.75f)
                lineTo(16.0f, 5.46f)
                curveToRelative(-0.39f, -0.18f, -0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(1.75f, -0.79f)
                lineTo(18.54f, 2.0f)
                curveToRelative(0.18f, -0.39f, 0.73f, -0.39f, 0.91f, 0.0f)
                lineTo(20.25f, 3.75f)
                close()
                moveTo(20.25f, 17.75f)
                lineTo(22.0f, 18.54f)
                curveToRelative(0.39f, 0.18f, 0.39f, 0.73f, 0.0f, 0.91f)
                lineToRelative(-1.75f, 0.79f)
                lineTo(19.46f, 22.0f)
                curveToRelative(-0.18f, 0.39f, -0.73f, 0.39f, -0.91f, 0.0f)
                lineToRelative(-0.79f, -1.75f)
                lineTo(16.0f, 19.46f)
                curveToRelative(-0.39f, -0.18f, -0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(1.75f, -0.79f)
                lineTo(18.54f, 16.0f)
                curveToRelative(0.18f, -0.39f, 0.73f, -0.39f, 0.91f, 0.0f)
                lineTo(20.25f, 17.75f)
                close()
            }
        }
        return _generatingTokens!!
    }

private var _generatingTokens: ImageVector? = null
