/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.MenuBook: ImageVector
    get() {
        if (_menuBook != null) {
            return _menuBook!!
        }
        _menuBook = materialIcon(name = "Rounded.MenuBook") {
            materialPath {
                moveTo(17.5f, 4.5f)
                curveToRelative(-1.95f, 0.0f, -4.05f, 0.4f, -5.5f, 1.5f)
                curveToRelative(-1.45f, -1.1f, -3.55f, -1.5f, -5.5f, -1.5f)
                curveToRelative(-1.45f, 0.0f, -2.99f, 0.22f, -4.28f, 0.79f)
                curveTo(1.49f, 5.62f, 1.0f, 6.33f, 1.0f, 7.14f)
                lineToRelative(0.0f, 11.28f)
                curveToRelative(0.0f, 1.3f, 1.22f, 2.26f, 2.48f, 1.94f)
                curveTo(4.46f, 20.11f, 5.5f, 20.0f, 6.5f, 20.0f)
                curveToRelative(1.56f, 0.0f, 3.22f, 0.26f, 4.56f, 0.92f)
                curveToRelative(0.6f, 0.3f, 1.28f, 0.3f, 1.87f, 0.0f)
                curveToRelative(1.34f, -0.67f, 3.0f, -0.92f, 4.56f, -0.92f)
                curveToRelative(1.0f, 0.0f, 2.04f, 0.11f, 3.02f, 0.36f)
                curveToRelative(1.26f, 0.33f, 2.48f, -0.63f, 2.48f, -1.94f)
                lineToRelative(0.0f, -11.28f)
                curveToRelative(0.0f, -0.81f, -0.49f, -1.52f, -1.22f, -1.85f)
                curveTo(20.49f, 4.72f, 18.95f, 4.5f, 17.5f, 4.5f)
                close()
                moveTo(21.0f, 17.23f)
                curveToRelative(0.0f, 0.63f, -0.58f, 1.09f, -1.2f, 0.98f)
                curveToRelative(-0.75f, -0.14f, -1.53f, -0.2f, -2.3f, -0.2f)
                curveToRelative(-1.7f, 0.0f, -4.15f, 0.65f, -5.5f, 1.5f)
                verticalLineTo(8.0f)
                curveToRelative(1.35f, -0.85f, 3.8f, -1.5f, 5.5f, -1.5f)
                curveToRelative(0.92f, 0.0f, 1.83f, 0.09f, 2.7f, 0.28f)
                curveToRelative(0.46f, 0.1f, 0.8f, 0.51f, 0.8f, 0.98f)
                verticalLineTo(17.23f)
                close()
            }
            materialPath {
                moveTo(13.98f, 11.01f)
                curveToRelative(-0.32f, 0.0f, -0.61f, -0.2f, -0.71f, -0.52f)
                curveToRelative(-0.13f, -0.39f, 0.09f, -0.82f, 0.48f, -0.94f)
                curveToRelative(1.54f, -0.5f, 3.53f, -0.66f, 5.36f, -0.45f)
                curveToRelative(0.41f, 0.05f, 0.71f, 0.42f, 0.66f, 0.83f)
                curveToRelative(-0.05f, 0.41f, -0.42f, 0.71f, -0.83f, 0.66f)
                curveToRelative(-1.62f, -0.19f, -3.39f, -0.04f, -4.73f, 0.39f)
                curveTo(14.13f, 10.99f, 14.05f, 11.01f, 13.98f, 11.01f)
                close()
            }
            materialPath {
                moveTo(13.98f, 13.67f)
                curveToRelative(-0.32f, 0.0f, -0.61f, -0.2f, -0.71f, -0.52f)
                curveToRelative(-0.13f, -0.39f, 0.09f, -0.82f, 0.48f, -0.94f)
                curveToRelative(1.53f, -0.5f, 3.53f, -0.66f, 5.36f, -0.45f)
                curveToRelative(0.41f, 0.05f, 0.71f, 0.42f, 0.66f, 0.83f)
                curveToRelative(-0.05f, 0.41f, -0.42f, 0.71f, -0.83f, 0.66f)
                curveToRelative(-1.62f, -0.19f, -3.39f, -0.04f, -4.73f, 0.39f)
                curveTo(14.13f, 13.66f, 14.05f, 13.67f, 13.98f, 13.67f)
                close()
            }
            materialPath {
                moveTo(13.98f, 16.33f)
                curveToRelative(-0.32f, 0.0f, -0.61f, -0.2f, -0.71f, -0.52f)
                curveToRelative(-0.13f, -0.39f, 0.09f, -0.82f, 0.48f, -0.94f)
                curveToRelative(1.53f, -0.5f, 3.53f, -0.66f, 5.36f, -0.45f)
                curveToRelative(0.41f, 0.05f, 0.71f, 0.42f, 0.66f, 0.83f)
                curveToRelative(-0.05f, 0.41f, -0.42f, 0.7f, -0.83f, 0.66f)
                curveToRelative(-1.62f, -0.19f, -3.39f, -0.04f, -4.73f, 0.39f)
                curveTo(14.13f, 16.32f, 14.05f, 16.33f, 13.98f, 16.33f)
                close()
            }
        }
        return _menuBook!!
    }

private var _menuBook: ImageVector? = null
