/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NearbyError: ImageVector
    get() {
        if (_nearbyError != null) {
            return _nearbyError!!
        }
        _nearbyError = materialIcon(name = "Rounded.NearbyError") {
            materialPath {
                moveTo(11.29f, 8.28f)
                lineToRelative(-3.01f, 3.01f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.01f, 3.01f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.01f, -3.01f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-3.01f, -3.01f)
                curveTo(12.32f, 7.89f, 11.68f, 7.89f, 11.29f, 8.28f)
                close()
            }
            materialPath {
                moveTo(10.59f, 2.59f)
                lineToRelative(-8.01f, 8.0f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(8.01f, 8.0f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineTo(18.0f, 16.82f)
                verticalLineTo(13.2f)
                lineToRelative(-6.0f, 6.0f)
                lineTo(4.79f, 12.0f)
                lineTo(12.0f, 4.79f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(7.17f)
                lineToRelative(-4.58f, -4.58f)
                curveTo(12.64f, 1.8f, 11.37f, 1.8f, 10.59f, 2.59f)
                close()
            }
            materialPath {
                moveTo(20.0f, 11.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-6.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveTo(20.45f, 10.0f, 20.0f, 10.45f, 20.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 21.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
        }
        return _nearbyError!!
    }

private var _nearbyError: ImageVector? = null
