/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TextRotationAngledown: ImageVector
    get() {
        if (_textRotationAngledown != null) {
            return _textRotationAngledown!!
        }
        _textRotationAngledown = materialIcon(name = "Rounded.TextRotationAngledown") {
            materialPath {
                moveTo(15.0f, 20.5f)
                verticalLineToRelative(-2.54f)
                curveToRelative(0.0f, -0.45f, -0.54f, -0.67f, -0.85f, -0.35f)
                lineToRelative(-0.56f, 0.56f)
                lineTo(5.1f, 9.68f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(8.49f, 8.49f)
                lineToRelative(-0.56f, 0.56f)
                curveToRelative(-0.32f, 0.32f, -0.1f, 0.86f, 0.34f, 0.86f)
                horizontalLineToRelative(2.54f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.23f, 0.5f, -0.5f)
                close()
                moveTo(11.25f, 8.48f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(-0.67f, 1.6f)
                curveToRelative(-0.15f, 0.36f, -0.07f, 0.77f, 0.21f, 1.05f)
                curveToRelative(0.49f, 0.49f, 1.31f, 0.32f, 1.57f, -0.32f)
                lineToRelative(3.61f, -9.09f)
                curveToRelative(0.17f, -0.42f, 0.07f, -0.91f, -0.25f, -1.23f)
                curveToRelative(-0.32f, -0.32f, -0.8f, -0.42f, -1.23f, -0.25f)
                lineToRelative(-9.1f, 3.6f)
                curveToRelative(-0.64f, 0.25f, -0.81f, 1.08f, -0.32f, 1.57f)
                curveToRelative(0.27f, 0.27f, 0.68f, 0.35f, 1.04f, 0.2f)
                lineToRelative(1.6f, -0.67f)
                close()
                moveTo(17.84f, 5.43f)
                lineToRelative(-2.23f, 4.87f)
                lineToRelative(-2.64f, -2.64f)
                lineToRelative(4.87f, -2.23f)
                close()
            }
        }
        return _textRotationAngledown!!
    }

private var _textRotationAngledown: ImageVector? = null
