/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded._1k: ImageVector
    get() {
        if (__1k != null) {
            return __1k!!
        }
        __1k = materialIcon(name = "Rounded._1k") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(9.25f, 15.0f)
                lineTo(9.25f, 15.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineTo(10.5f)
                horizontalLineTo(7.75f)
                curveTo(7.34f, 10.5f, 7.0f, 10.16f, 7.0f, 9.75f)
                verticalLineToRelative(0.0f)
                curveTo(7.0f, 9.34f, 7.34f, 9.0f, 7.75f, 9.0f)
                horizontalLineTo(9.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.25f)
                curveTo(10.0f, 14.66f, 9.66f, 15.0f, 9.25f, 15.0f)
                close()
                moveTo(15.59f, 15.0f)
                lineTo(15.59f, 15.0f)
                curveToRelative(-0.22f, 0.0f, -0.42f, -0.1f, -0.55f, -0.27f)
                lineToRelative(-1.54f, -1.98f)
                verticalLineToRelative(1.5f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineToRelative(0.0f)
                curveTo(12.34f, 15.0f, 12.0f, 14.66f, 12.0f, 14.25f)
                verticalLineToRelative(-4.5f)
                curveTo(12.0f, 9.34f, 12.34f, 9.0f, 12.75f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(1.5f)
                lineToRelative(1.54f, -1.98f)
                curveTo(15.17f, 9.1f, 15.38f, 9.0f, 15.59f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.58f, 0.0f, 0.91f, 0.66f, 0.56f, 1.12f)
                lineTo(14.75f, 12.0f)
                lineToRelative(1.41f, 1.88f)
                curveTo(16.5f, 14.34f, 16.17f, 15.0f, 15.59f, 15.0f)
                close()
            }
        }
        return __1k!!
    }

private var __1k: ImageVector? = null
