/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AutoFixNormal: ImageVector
    get() {
        if (_autoFixNormal != null) {
            return _autoFixNormal!!
        }
        _autoFixNormal = materialIcon(name = "Sharp.AutoFixNormal") {
            materialPath {
                moveTo(20.0f, 7.0f)
                lineToRelative(0.94f, -2.06f)
                lineToRelative(2.06f, -0.94f)
                lineToRelative(-2.06f, -0.94f)
                lineToRelative(-0.94f, -2.06f)
                lineToRelative(-0.94f, 2.06f)
                lineToRelative(-2.06f, 0.94f)
                lineToRelative(2.06f, 0.94f)
                close()
            }
            materialPath {
                moveTo(18.41f, 9.83f)
                lineToRelative(-4.24f, -4.24f)
                lineTo(1.59f, 18.17f)
                lineToRelative(4.24f, 4.24f)
                lineTo(18.41f, 9.83f)
                close()
                moveTo(14.21f, 11.21f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(1.38f, -1.38f)
                lineToRelative(1.41f, 1.41f)
                lineTo(14.21f, 11.21f)
                close()
            }
        }
        return _autoFixNormal!!
    }

private var _autoFixNormal: ImageVector? = null
