/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AutoFixOff: ImageVector
    get() {
        if (_autoFixOff != null) {
            return _autoFixOff!!
        }
        _autoFixOff = materialIcon(name = "Sharp.AutoFixOff") {
            materialPath {
                moveTo(20.0f, 7.0f)
                lineToRelative(0.94f, -2.06f)
                lineToRelative(2.06f, -0.94f)
                lineToRelative(-2.06f, -0.94f)
                lineToRelative(-0.94f, -2.06f)
                lineToRelative(-0.94f, 2.06f)
                lineToRelative(-2.06f, 0.94f)
                lineToRelative(2.06f, 0.94f)
                close()
            }
            materialPath {
                moveTo(14.17f, 8.42f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-1.46f, 1.46f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(2.87f, -2.88f)
                lineToRelative(-4.24f, -4.24f)
                lineToRelative(-2.88f, 2.87f)
                lineToRelative(1.42f, 1.42f)
                close()
            }
            materialPath {
                moveTo(1.39f, 4.22f)
                lineToRelative(7.07f, 7.07f)
                lineToRelative(-6.87f, 6.88f)
                lineToRelative(4.24f, 4.24f)
                lineToRelative(6.88f, -6.87f)
                lineToRelative(7.07f, 7.07f)
                lineToRelative(1.41f, -1.42f)
                lineToRelative(-18.38f, -18.38f)
                close()
            }
        }
        return _autoFixOff!!
    }

private var _autoFixOff: ImageVector? = null
