/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DesignServices: ImageVector
    get() {
        if (_designServices != null) {
            return _designServices!!
        }
        _designServices = materialIcon(name = "Sharp.DesignServices") {
            materialPath {
                moveTo(21.79f, 17.06f)
                lineToRelative(-5.55f, -5.55f)
                lineToRelative(1.57f, -1.57f)
                lineToRelative(-3.75f, -3.75f)
                lineToRelative(-1.57f, 1.57f)
                lineTo(6.94f, 2.21f)
                lineTo(2.21f, 6.94f)
                lineToRelative(5.55f, 5.55f)
                lineTo(3.0f, 17.25f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(3.75f)
                lineToRelative(4.76f, -4.76f)
                lineToRelative(5.55f, 5.55f)
                lineToRelative(0.0f, 0.0f)
                verticalLineToRelative(0.0f)
                lineTo(21.79f, 17.06f)
                close()
                moveTo(9.18f, 11.07f)
                lineTo(5.04f, 6.94f)
                lineToRelative(1.9f, -1.9f)
                lineToRelative(1.27f, 1.27f)
                lineTo(7.02f, 7.5f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.19f, -1.19f)
                lineToRelative(1.45f, 1.45f)
                lineTo(9.18f, 11.07f)
                close()
                moveTo(12.93f, 14.82f)
                lineToRelative(1.9f, -1.9f)
                lineToRelative(1.45f, 1.45f)
                lineToRelative(-1.19f, 1.19f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(1.19f, -1.19f)
                lineToRelative(1.27f, 1.27f)
                lineToRelative(-1.9f, 1.9f)
                lineTo(12.93f, 14.82f)
                close()
            }
            materialPath {
                moveTo(15.133f, 5.123f)
                lineToRelative(2.538f, -2.538f)
                lineToRelative(3.748f, 3.748f)
                lineToRelative(-2.538f, 2.538f)
                close()
            }
        }
        return _designServices!!
    }

private var _designServices: ImageVector? = null
