/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FeaturedVideo: ImageVector
    get() {
        if (_featuredVideo != null) {
            return _featuredVideo!!
        }
        _featuredVideo = materialIcon(name = "Sharp.FeaturedVideo") {
            materialPath {
                moveTo(23.0f, 3.0f)
                lineTo(1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(22.0f)
                lineTo(23.0f, 3.0f)
                close()
                moveTo(12.0f, 12.0f)
                lineTo(3.0f, 12.0f)
                lineTo(3.0f, 5.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(7.0f)
                close()
            }
        }
        return _featuredVideo!!
    }

private var _featuredVideo: ImageVector? = null
