/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FontDownloadOff: ImageVector
    get() {
        if (_fontDownloadOff != null) {
            return _fontDownloadOff!!
        }
        _fontDownloadOff = materialIcon(name = "Sharp.FontDownloadOff") {
            materialPath {
                moveTo(12.58f, 9.75f)
                lineToRelative(-0.87f, -0.87f)
                lineToRelative(0.23f, -0.66f)
                horizontalLineToRelative(0.1f)
                lineTo(12.58f, 9.75f)
                close()
                moveTo(20.49f, 23.31f)
                lineTo(19.17f, 22.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(4.83f)
                lineTo(0.69f, 3.51f)
                lineTo(2.1f, 2.1f)
                lineToRelative(19.8f, 19.8f)
                lineTo(20.49f, 23.31f)
                close()
                moveTo(12.1f, 14.93f)
                lineToRelative(-3.3f, -3.3f)
                lineTo(6.41f, 18.0f)
                horizontalLineToRelative(2.08f)
                lineToRelative(1.09f, -3.07f)
                horizontalLineTo(12.1f)
                close()
                moveTo(10.35f, 7.52f)
                lineTo(10.92f, 6.0f)
                horizontalLineToRelative(2.14f)
                lineToRelative(2.55f, 6.79f)
                lineTo(22.0f, 19.17f)
                verticalLineTo(2.0f)
                horizontalLineTo(4.83f)
                lineTo(10.35f, 7.52f)
                close()
            }
        }
        return _fontDownloadOff!!
    }

private var _fontDownloadOff: ImageVector? = null
