/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Handshake: ImageVector
    get() {
        if (_handshake != null) {
            return _handshake!!
        }
        _handshake = materialIcon(name = "Sharp.Handshake") {
            materialPath {
                moveTo(10.59f, 5.95f)
                lineToRelative(-7.05f, 7.04f)
                lineTo(0.7f, 10.3f)
                lineToRelative(8.55f, -8.55f)
                lineToRelative(7.95f, 7.95f)
                lineToRelative(-1.42f, 1.42f)
                lineTo(10.59f, 5.95f)
                close()
                moveTo(23.24f, 10.24f)
                lineToRelative(-8.49f, -8.49f)
                lineToRelative(-2.06f, 2.06f)
                lineToRelative(5.9f, 5.88f)
                lineToRelative(-2.83f, 2.83f)
                lineToRelative(-5.17f, -5.17f)
                lineToRelative(-6.27f, 6.27f)
                lineToRelative(1.42f, 1.41f)
                lineToRelative(5.32f, -5.32f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(-5.32f, 5.32f)
                lineToRelative(1.42f, 1.41f)
                lineToRelative(5.32f, -5.32f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(-5.32f, 5.32f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(5.32f, -5.32f)
                lineToRelative(0.71f, 0.71f)
                lineTo(10.68f, 20.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(23.24f, 10.24f)
                close()
            }
        }
        return _handshake!!
    }

private var _handshake: ImageVector? = null
