/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.LabelImportant: ImageVector
    get() {
        if (_labelImportant != null) {
            return _labelImportant!!
        }
        _labelImportant = materialIcon(name = "Sharp.LabelImportant") {
            materialPath {
                moveTo(4.0f, 18.99f)
                horizontalLineToRelative(12.04f)
                lineTo(21.0f, 12.0f)
                lineToRelative(-4.97f, -7.0f)
                horizontalLineTo(4.0f)
                lineToRelative(5.0f, 7.0f)
                lineToRelative(-5.0f, 6.99f)
                close()
            }
        }
        return _labelImportant!!
    }

private var _labelImportant: ImageVector? = null
