/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Score: ImageVector
    get() {
        if (_score != null) {
            return _score!!
        }
        _score = materialIcon(name = "Sharp.Score") {
            materialPath {
                moveTo(21.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(18.0f)
                lineTo(21.0f, 3.0f)
                close()
                moveTo(12.0f, 5.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.0f, -3.0f)
                horizontalLineToRelative(1.7f)
                lineToRelative(-2.0f, 3.0f)
                lineToRelative(2.0f, 3.0f)
                horizontalLineToRelative(-1.7f)
                lineToRelative(-2.0f, -3.0f)
                verticalLineToRelative(3.0f)
                lineTo(12.0f, 11.0f)
                lineTo(12.0f, 5.0f)
                close()
                moveTo(7.0f, 7.25f)
                horizontalLineToRelative(2.5f)
                lineTo(9.5f, 6.5f)
                lineTo(7.0f, 6.5f)
                lineTo(7.0f, 5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(3.75f)
                lineTo(8.5f, 8.75f)
                verticalLineToRelative(0.75f)
                lineTo(11.0f, 9.5f)
                lineTo(11.0f, 11.0f)
                lineTo(7.0f, 11.0f)
                lineTo(7.0f, 7.25f)
                close()
                moveTo(19.0f, 13.0f)
                lineToRelative(-6.0f, 6.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-4.0f, 4.0f)
                verticalLineToRelative(-2.5f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(6.0f, -6.0f)
                lineTo(19.0f, 13.0f)
                close()
            }
        }
        return _score!!
    }

private var _score: ImageVector? = null
