/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ViewWeek: ImageVector
    get() {
        if (_viewWeek != null) {
            return _viewWeek!!
        }
        _viewWeek = materialIcon(name = "Sharp.ViewWeek") {
            materialPath {
                moveTo(7.33f, 20.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(5.33f)
                verticalLineTo(20.0f)
                close()
                moveTo(22.0f, 20.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(-5.33f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(22.0f)
                close()
                moveTo(14.67f, 20.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(9.33f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(14.67f)
                close()
            }
        }
        return _viewWeek!!
    }

private var _viewWeek: ImageVector? = null
