/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Person2: ImageVector
    get() {
        if (_person2 != null) {
            return _person2!!
        }
        _person2 = materialIcon(name = "Filled.Person2") {
            materialPath {
                moveTo(18.39f, 14.56f)
                curveTo(16.71f, 13.7f, 14.53f, 13.0f, 12.0f, 13.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(4.61f, 15.07f, 4.0f, 16.1f, 4.0f, 17.22f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.78f)
                curveTo(20.0f, 16.1f, 19.39f, 15.07f, 18.39f, 14.56f)
                close()
            }
            materialPath {
                moveTo(9.78f, 12.0f)
                horizontalLineToRelative(4.44f)
                curveToRelative(1.21f, 0.0f, 2.14f, -1.06f, 1.98f, -2.26f)
                lineToRelative(-0.32f, -2.45f)
                curveTo(15.57f, 5.39f, 13.92f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(8.43f, 5.39f, 8.12f, 7.29f)
                lineTo(7.8f, 9.74f)
                curveTo(7.64f, 10.94f, 8.57f, 12.0f, 9.78f, 12.0f)
                close()
            }
        }
        return _person2!!
    }

private var _person2: ImageVector? = null
