/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Girl: ImageVector
    get() {
        if (_girl != null) {
            return _girl!!
        }
        _girl = materialIcon(name = "Sharp.Girl") {
            materialPath {
                moveTo(12.0f, 7.5f)
                curveToRelative(0.97f, 0.0f, 1.75f, -0.78f, 1.75f, -1.75f)
                reflectiveCurveTo(12.97f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveToRelative(-1.75f, 0.78f, -1.75f, 1.75f)
                reflectiveCurveTo(11.03f, 7.5f, 12.0f, 7.5f)
                close()
                moveTo(14.0f, 16.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(8.0f)
                lineToRelative(2.38f, -6.38f)
                curveTo(10.63f, 8.95f, 11.28f, 8.5f, 12.0f, 8.5f)
                reflectiveCurveToRelative(1.37f, 0.45f, 1.62f, 1.12f)
                lineTo(16.0f, 16.0f)
                horizontalLineTo(14.0f)
                close()
            }
        }
        return _girl!!
    }

private var _girl: ImageVector? = null
