/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Loyalty: ImageVector
    get() {
        if (_loyalty != null) {
            return _loyalty!!
        }
        _loyalty = materialIcon(name = "Sharp.Loyalty") {
            materialPath {
                moveTo(11.83f, 2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(9.83f)
                lineToRelative(10.99f, 11.0f)
                reflectiveCurveToRelative(1.05f, -1.05f, 1.41f, -1.42f)
                lineTo(22.82f, 13.0f)
                lineTo(11.83f, 2.0f)
                close()
                moveTo(5.5f, 7.0f)
                curveTo(4.67f, 7.0f, 4.0f, 6.33f, 4.0f, 5.5f)
                reflectiveCurveTo(4.67f, 4.0f, 5.5f, 4.0f)
                reflectiveCurveTo(7.0f, 4.67f, 7.0f, 5.5f)
                reflectiveCurveTo(6.33f, 7.0f, 5.5f, 7.0f)
                close()
                moveTo(13.0f, 19.54f)
                lineToRelative(-4.27f, -4.27f)
                curveTo(8.28f, 14.81f, 8.0f, 14.19f, 8.0f, 13.5f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                curveToRelative(0.69f, 0.0f, 1.32f, 0.28f, 1.77f, 0.74f)
                lineToRelative(0.73f, 0.72f)
                lineToRelative(0.73f, -0.73f)
                curveToRelative(0.45f, -0.45f, 1.08f, -0.73f, 1.77f, -0.73f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.12f, 2.5f, 2.5f)
                curveToRelative(0.0f, 0.69f, -0.28f, 1.32f, -0.73f, 1.77f)
                lineTo(13.0f, 19.54f)
                close()
            }
        }
        return _loyalty!!
    }

private var _loyalty: ImageVector? = null
