/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Woman: ImageVector
    get() {
        if (_woman != null) {
            return _woman!!
        }
        _woman = materialIcon(name = "Sharp.Woman") {
            materialPath {
                moveTo(13.41f, 7.0f)
                lineToRelative(-2.82f, 0.0f)
                lineToRelative(-3.59f, 9.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(3.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _woman!!
    }

private var _woman: ImageVector? = null
